/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.BAMFileConstants;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.util.BlockCompressedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.zip.GZIPInputStream;

public class SamStreams {
    private static int readBytes(InputStream stream, byte[] buffer, int offset, int length) throws IOException {
        int bytesRead;
        int count;
        for (bytesRead = 0; bytesRead < length && (count = stream.read(buffer, offset + bytesRead, length - bytesRead)) > 0; bytesRead += count) {
        }
        return bytesRead;
    }

    public static boolean isBAMFile(InputStream stream) throws IOException {
        if (!BlockCompressedInputStream.isValidFile(stream)) {
            return false;
        }
        int buffSize = 65536;
        stream.mark(65536);
        byte[] buffer = new byte[65536];
        SamStreams.readBytes(stream, buffer, 0, 65536);
        stream.reset();
        byte[] magicBuf = new byte[4];
        int magicLength = SamStreams.readBytes(new BlockCompressedInputStream(new ByteArrayInputStream(buffer)), magicBuf, 0, 4);
        return magicLength == BAMFileConstants.BAM_MAGIC.length && Arrays.equals(BAMFileConstants.BAM_MAGIC, magicBuf);
    }

    public static boolean sourceLikeBam(SeekableStream strm) {
        String source = strm.getSource();
        if (source == null) {
            return true;
        }
        return (source = source.toLowerCase()).endsWith(".bam") || source.contains(".bam?") || source.contains(".bam&") || source.contains(".bam%26");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isGzippedSAMFile(InputStream stream) {
        if (!stream.markSupported()) {
            throw new IllegalArgumentException("Cannot test a stream that doesn't support marking.");
        }
        stream.mark(8000);
        try {
            GZIPInputStream gunzip = new GZIPInputStream(stream);
            int ch = gunzip.read();
            boolean bl = true;
            return bl;
        }
        catch (IOException ioe) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                stream.reset();
            }
            catch (IOException ioe) {
                throw new IllegalStateException("Could not reset stream.");
            }
        }
    }
}

