/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.BAMIndexMetaData;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import java.io.File;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.Option;
import picard.cmdline.Usage;
import picard.sam.BuildBamIndex;

public class BamIndexStats
extends CommandLineProgram {
    private static final Log log = Log.getInstance(BuildBamIndex.class);
    @Usage
    public String USAGE = this.getStandardUsagePreamble() + "Generates BAM index statistics. " + "Input BAM file must have a corresponding index file.\n";
    @Option(shortName="I", doc="A BAM file to process.")
    public File INPUT;

    public static void main(String[] argv) {
        System.exit(new BamIndexStats().instanceMain(argv));
    }

    @Override
    protected int doWork() {
        if (this.INPUT.getName().endsWith(".bai")) {
            log.warn(new Object[]{"INPUT should be BAM file not index file"});
        }
        IOUtil.assertFileIsReadable((File)this.INPUT);
        BAMIndexMetaData.printIndexStats((File)this.INPUT);
        return 0;
    }
}

