/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileReader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import java.io.File;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.Option;
import picard.cmdline.Usage;

public class SamFormatConverter
extends CommandLineProgram {
    private static final String PROGRAM_VERSION = "1.0";
    @Usage
    public String USAGE = this.getStandardUsagePreamble() + "Convert a BAM file to a SAM file, or BAM to SAM.\n" + "" + "Input and output formats are determined by file extension.";
    @Option(doc="The BAM or SAM file to parse.", shortName="I")
    public File INPUT;
    @Option(doc="The BAM or SAM output file. ", shortName="O")
    public File OUTPUT;

    public static void main(String[] argv) {
        new SamFormatConverter().instanceMainWithExit(argv);
    }

    @Override
    protected int doWork() {
        IOUtil.assertFileIsReadable((File)this.INPUT);
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        SAMFileReader reader = new SAMFileReader(this.INPUT);
        SAMFileWriter writer = new SAMFileWriterFactory().makeSAMOrBAMWriter(reader.getFileHeader(), true, this.OUTPUT);
        if (this.CREATE_INDEX.booleanValue() && writer.getFileHeader().getSortOrder() != SAMFileHeader.SortOrder.coordinate) {
            throw new PicardException("Can't CREATE_INDEX unless sort order is coordinate");
        }
        ProgressLogger progress = new ProgressLogger(Log.getInstance(SamFormatConverter.class));
        for (SAMRecord rec : reader) {
            writer.addAlignment(rec);
            progress.record(rec);
        }
        reader.close();
        writer.close();
        return 0;
    }
}

