/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.AsyncSAMFileWriter;
import htsjdk.samtools.BAMFileWriter;
import htsjdk.samtools.CRAMFileWriter;
import htsjdk.samtools.Defaults;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterImpl;
import htsjdk.samtools.SAMTextWriter;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.cram.ref.ReferenceSource;
import htsjdk.samtools.util.BlockCompressedOutputStream;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Md5CalculatingOutputStream;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class SAMFileWriterFactory {
    private static boolean defaultCreateIndexWhileWriting = Defaults.CREATE_INDEX;
    private boolean createIndex = defaultCreateIndexWhileWriting;
    private static boolean defaultCreateMd5File = Defaults.CREATE_MD5;
    private boolean createMd5File = defaultCreateMd5File;
    private boolean useAsyncIo = Defaults.USE_ASYNC_IO;
    private int asyncOutputBufferSize = 2000;
    private int bufferSize = Defaults.BUFFER_SIZE;
    private File tmpDir;
    private Integer maxRecordsInRam;

    public static void setDefaultCreateMd5File(boolean createMd5File) {
        defaultCreateMd5File = createMd5File;
    }

    public SAMFileWriterFactory setCreateMd5File(boolean createMd5File) {
        this.createMd5File = createMd5File;
        return this;
    }

    public static void setDefaultCreateIndexWhileWriting(boolean setting) {
        defaultCreateIndexWhileWriting = setting;
    }

    public SAMFileWriterFactory setCreateIndex(boolean setting) {
        this.createIndex = setting;
        return this;
    }

    public SAMFileWriterFactory setMaxRecordsInRam(int maxRecordsInRam) {
        this.maxRecordsInRam = maxRecordsInRam;
        return this;
    }

    public SAMFileWriterFactory setUseAsyncIo(boolean useAsyncIo) {
        this.useAsyncIo = useAsyncIo;
        return this;
    }

    public SAMFileWriterFactory setAsyncOutputBufferSize(int asyncOutputBufferSize) {
        this.asyncOutputBufferSize = asyncOutputBufferSize;
        return this;
    }

    public SAMFileWriterFactory setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
        return this;
    }

    public SAMFileWriterFactory setTempDirectory(File tmpDir) {
        this.tmpDir = tmpDir;
        return this;
    }

    public SAMFileWriter makeBAMWriter(SAMFileHeader header, boolean presorted, File outputFile) {
        return this.makeBAMWriter(header, presorted, outputFile, BlockCompressedOutputStream.getDefaultCompressionLevel());
    }

    public SAMFileWriter makeBAMWriter(SAMFileHeader header, boolean presorted, File outputFile, int compressionLevel) {
        try {
            boolean createIndex;
            boolean createMd5File;
            boolean bl = createMd5File = this.createMd5File && IOUtil.isRegularPath(outputFile);
            if (this.createMd5File && !createMd5File) {
                System.err.println("Cannot create MD5 file for BAM because output file is not a regular file: " + outputFile.getAbsolutePath());
            }
            OutputStream os = IOUtil.maybeBufferOutputStream(new FileOutputStream(outputFile, false), this.bufferSize);
            if (createMd5File) {
                os = new Md5CalculatingOutputStream(os, new File(outputFile.getAbsolutePath() + ".md5"));
            }
            BAMFileWriter ret = new BAMFileWriter(os, outputFile, compressionLevel);
            boolean bl2 = createIndex = this.createIndex && IOUtil.isRegularPath(outputFile);
            if (this.createIndex && !createIndex) {
                System.err.println("Cannot create index for BAM because output file is not a regular file: " + outputFile.getAbsolutePath());
            }
            if (this.tmpDir != null) {
                ret.setTempDirectory(this.tmpDir);
            }
            this.initializeBAMWriter(ret, header, presorted, createIndex);
            if (this.useAsyncIo) {
                return new AsyncSAMFileWriter(ret, this.asyncOutputBufferSize);
            }
            return ret;
        }
        catch (IOException ioe) {
            throw new RuntimeIOException("Error opening file: " + outputFile.getAbsolutePath());
        }
    }

    private void initializeBAMWriter(BAMFileWriter writer, SAMFileHeader header, boolean presorted, boolean createIndex) {
        writer.setSortOrder(header.getSortOrder(), presorted);
        if (this.maxRecordsInRam != null) {
            writer.setMaxRecordsInRam(this.maxRecordsInRam);
        }
        writer.setHeader(header);
        if (createIndex && writer.getSortOrder().equals((Object)SAMFileHeader.SortOrder.coordinate)) {
            writer.enableBamIndexConstruction();
        }
    }

    public SAMFileWriter makeSAMWriter(SAMFileHeader header, boolean presorted, File outputFile) {
        try {
            SAMTextWriter ret = this.createMd5File ? new SAMTextWriter(new Md5CalculatingOutputStream(new FileOutputStream(outputFile, false), new File(outputFile.getAbsolutePath() + ".md5"))) : new SAMTextWriter(outputFile);
            ret.setSortOrder(header.getSortOrder(), presorted);
            if (this.maxRecordsInRam != null) {
                ret.setMaxRecordsInRam(this.maxRecordsInRam);
            }
            ret.setHeader(header);
            if (this.useAsyncIo) {
                return new AsyncSAMFileWriter(ret, this.asyncOutputBufferSize);
            }
            return ret;
        }
        catch (IOException ioe) {
            throw new RuntimeIOException("Error opening file: " + outputFile.getAbsolutePath());
        }
    }

    public SAMFileWriter makeSAMWriter(SAMFileHeader header, boolean presorted, OutputStream stream) {
        return this.initWriter(header, presorted, false, new SAMTextWriter(stream));
    }

    public SAMFileWriter makeBAMWriter(SAMFileHeader header, boolean presorted, OutputStream stream) {
        return this.initWriter(header, presorted, true, new BAMFileWriter(stream, null));
    }

    private SAMFileWriter initWriter(SAMFileHeader header, boolean presorted, boolean binary, SAMFileWriterImpl writer) {
        writer.setSortOrder(header.getSortOrder(), presorted);
        if (this.maxRecordsInRam != null) {
            writer.setMaxRecordsInRam(this.maxRecordsInRam);
        }
        writer.setHeader(header);
        if (this.useAsyncIo) {
            return new AsyncSAMFileWriter(writer, this.asyncOutputBufferSize);
        }
        return writer;
    }

    public SAMFileWriter makeSAMOrBAMWriter(SAMFileHeader header, boolean presorted, File outputFile) {
        String filename = outputFile.getName();
        if (filename.endsWith(".bam")) {
            return this.makeBAMWriter(header, presorted, outputFile);
        }
        if (filename.endsWith(".sam")) {
            return this.makeSAMWriter(header, presorted, outputFile);
        }
        return this.makeBAMWriter(header, presorted, outputFile);
    }

    public SAMFileWriter makeWriter(SAMFileHeader header, boolean presorted, File outputFile, File referenceFasta) {
        if (outputFile.getName().endsWith(SamReader.Type.CRAM_TYPE.fileExtension())) {
            try {
                return this.makeCRAMWriter(header, new FileOutputStream(outputFile), referenceFasta);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeIOException(e);
            }
        }
        return this.makeSAMOrBAMWriter(header, presorted, outputFile);
    }

    public CRAMFileWriter makeCRAMWriter(SAMFileHeader header, OutputStream stream, File referenceFasta) {
        CRAMFileWriter writer = new CRAMFileWriter(stream, new ReferenceSource(referenceFasta), header, null);
        writer.setPreserveReadNames(true);
        writer.setCaptureAllTags(true);
        return writer;
    }

    public CRAMFileWriter makeCRAMWriter(SAMFileHeader header, File outputFile, File referenceFasta) {
        boolean createIndex;
        boolean bl = createIndex = this.createIndex && IOUtil.isRegularPath(outputFile);
        if (this.createIndex && !createIndex) {
            System.err.println("Cannot create index for CAM because output file is not a regular file: " + outputFile.getAbsolutePath());
        }
        try {
            FileOutputStream indexOS = null;
            if (createIndex) {
                File indexFile = new File(outputFile.getAbsolutePath() + ".bai");
                indexOS = new FileOutputStream(indexFile);
            }
            CRAMFileWriter writer = new CRAMFileWriter(new FileOutputStream(outputFile), indexOS, new ReferenceSource(referenceFasta), header, null);
            writer.setPreserveReadNames(true);
            writer.setCaptureAllTags(true);
            return writer;
        }
        catch (IOException ioe) {
            throw new RuntimeIOException("Error opening file: " + outputFile.getAbsolutePath());
        }
    }
}

