/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.html;

import java.io.InputStream;
import java.net.URL;
import org.xml.sax.InputSource;

public class DTDMapper {
    private static final String xhtml1Frameset = "-//W3C//DTD XHTML 1.0 FRAMESET//EN";
    private static final String xhtml1Strict = "-//W3C//DTD XHTML 1.0 STRICT//EN";
    private static final String xhtml1Transitional = "-//W3C//DTD XHTML 1.0 TRANSITIONAL//EN";
    private static final String xhtml11 = "-//W3C//DTD XHTML 1.1//EN";
    private static final String latin1Ent = "-//W3C//ENTITIES LATIN 1 FOR XHTML//EN";
    private static final String specialEnt = "-//W3C//ENTITIES SPECIAL FOR XHTML//EN";
    private static final String symbolEnt = "-//W3C//ENTITIES SYMBOLS FOR XHTML//EN";

    public static InputSource publicIDToFile(String string) {
        URL uRL;
        String string2 = null;
        if (string == null) {
            return null;
        }
        if (xhtml1Frameset.equals(string = string.toUpperCase())) {
            string2 = "xhtml1-frameset.dtd";
        } else if (xhtml1Strict.equals(string)) {
            string2 = "xhtml1-strict.dtd";
        } else if (xhtml1Transitional.equals(string)) {
            string2 = "xhtml1-transitional.dtd";
        } else if (xhtml11.equals(string)) {
            string2 = "xhtml11-flat.dtd";
        } else if (latin1Ent.equals(string)) {
            string2 = "xhtml-lat1.ent";
        } else if (specialEnt.equals(string)) {
            string2 = "xhtml-special.ent";
        } else if (symbolEnt.equals(string)) {
            string2 = "xhtml-symbol.ent";
        }
        if (string2 != null && (uRL = DTDMapper.class.getResource(string2)) != null) {
            try {
                InputStream inputStream = uRL.openStream();
                return new InputSource(inputStream);
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }

    public static boolean isXHTMLDTD(String string) {
        if (string == null) {
            return false;
        }
        return xhtml1Frameset.equals(string = string.toUpperCase()) || xhtml1Strict.equals(string) || xhtml1Transitional.equals(string) || xhtml11.equals(string);
    }

    public static String getXHTMLVersion(String string) {
        if (!DTDMapper.isXHTMLDTD(string = string.toUpperCase())) {
            return null;
        }
        if (xhtml11.equals(string)) {
            return "1.1";
        }
        return "1.0";
    }
}

