$! Rebuild PGPLOT shareable image.
$! Input file:   GRPCKG.OLB
$! Creates:      GRPSHR.EXE  (shareable image)
$!               GRPSHR.OLB  (shareable image symbol table library)
$!
$! A program which uses GRPCKG/PGPLOT routines can be linked
$!
$! either   with GRPCKG.OLB/LIB, in which case the routines are
$!          included in the executable image by the linker in the
$!          usual way;
$!     or   with GRPSHR.OLB/LIB, in which case the routines
$!	    will be included from the shareable image at run time;
$!          a logical name GRPSHR must be defined at run time,
$!          equivalent to disk:[directory]GRPSHR.EXE
$!
$!				- T.J. Pearson, 1-Aug-1984
$!----------------------------------------------------------------------
$ DELETE = "DELETE/NOLOG/NOCONFIRM"
$ PURGE  = "PURGE/NOLOG/NOCONFIRM"
$!
$! Check required libraries
$!
$ UIS = F$SEARCH("SYS$SHARE:UISSHR.EXE") 
$ XLIB = F$SEARCH("SYS$SHARE:DECW$XLIBSHR.EXE")
$ IF UIS.EQS."" 
$ THEN
$     WRITE SYS$OUTPUT "VAX Workstation Software (VWS) is not installed on this system"
$ ELSE
$     UIS = ",UIS.OPT/OPT"
$ ENDIF
$ IF XLIB.EQS."" 
$ THEN
$     WRITE SYS$OUTPUT "DECwindows is not installed on this system"
$ ELSE
$     XLIB = ",XLIB.OPT/OPT"
$ ENDIF
$ CREATE UIS.OPT
SYS$SHARE:UISSHR.EXE/SHARE
$ CREATE XLIB.OPT
SYS$SHARE:DECW$XLIBSHR.EXE/SHARE
$!
$! Check machine type
$!
$ ON WARNING THEN GOTO VAX
$ MACHINE=F$GETSYI("ARCH_NAME")
$ IF MACHINE .EQS. "AXP" THEN GOTO AXP
$ IF MACHINE .EQS. "Alpha" THEN GOTO AXP
$ GOTO VAX
$!----------------------------------------------------------------------
$! OpenVMS-VAX
$!----------------------------------------------------------------------
$VAX:
$ ON WARNING THEN EXIT
$ WRITE SYS$OUTPUT "Building PGPLOT shareable library for OpenVMS-VAX"
$ WRITE SYS$OUTPUT "(Ignore any error messages about ARCH_NAME)"
$!
$! Create a module containing transfer vectors into the shareable image.
$! This can only be done in MACRO.
$!
$ WRITE SYS$OUTPUT "Creating shareable image"
$ MACRO/OBJECT=GRPSHRTRN SYS$INPUT
	.TITLE GRPSHR Transfer Vector for GRPCKG/PGPLOT
	.IDENT /1-50/
;
; T.J. Pearson, 1-Jan-1984.
;
; This module contains all the transfer vectors into the shareable
; image GRPSHR.  Only user-callable routines have transfer vectors.
; If you change this file and want it to be compatible with a previous
; version, you must add transfer vectors only at the end of the list.
; If you remove a transfer vector, replace it with a pointer to an
; error processing routine. 
;
	.PSECT $TRANS,EXE,NOWRT,PIC,SHR,GBL

        .MACRO TRANS UNAME,LNAME
	.TRANSFER    UNAME
 	.IF NB       LNAME
	.MASK        LNAME
	JMP          LNAME+2
        .IFF
	.MASK        UNAME
        JMP          UNAME+2
        .ENDC
        .ENDM        TRANS

	TRANS	GRAREA
	TRANS	GRCHAR
	TRANS	GRCHSZ
	TRANS	GRCLOS
	TRANS	GRCURS
	TRANS	GRETXT
	TRANS	GRQCI
	TRANS	GRQDT
	TRANS   GRQFNT
	TRANS	GRINQLI
	TRANS	GRQLS
	TRANS	GRQLW
	TRANS	GRQTYP
	TRANS	GRLINA
	TRANS	GRLINR
	TRANS	GRMARK
	TRANS	GRMOVA
	TRANS	GRMOVR
	TRANS	GROPEN
	TRANS	GRPAGE
	TRANS	GRMKER
	TRANS	GRSLCT
	TRANS	GRSETC
	TRANS	GRSCI
	TRANS   GRSFNT
	TRANS	GRSETLI
	TRANS	GRSLS
	TRANS	GRSLW
	TRANS	GRSETS
	TRANS	GRSIZE
	TRANS	GRCHKT
	TRANS	GRTERM
	TRANS	GRTEXT
	TRANS	GRTRAN
	TRANS	GRVECT
	TRANS	PGADVANCE
	TRANS	PGASK
	TRANS	PGBEGIN
	TRANS	PGBIN
	TRANS	PGBOX
	TRANS	PGCNSC
	TRANS	PGCONT
	TRANS	PGCURSE
	TRANS	PGEND
	TRANS	PGENV
	TRANS	PGERRX
	TRANS	PGERRY
	TRANS	PGGRAY
	TRANS	PGHIST
	TRANS	PGLABEL
	TRANS	PGLINE
	TRANS	PGMTEXT
	TRANS	PGNCURSE
	TRANS	PGPOINT
	TRANS	PGSETC
	TRANS	PGSIZE
	TRANS	PGTEXT
	TRANS	PGVPORT
	TRANS	PGVSIZE
	TRANS	PGVSTAND
	TRANS	PGWINDOW
;
	TRANS   PGPAPER     ; 1-02 22-Apr-1983
	TRANS	PGPTEXT     ; 1-03  1-May-1983
	TRANS	PGFUNT      ; 1-04  5-Oct-1983
	TRANS   PGFUNX
	TRANS	PGFUNY
	TRANS   PGNUMB
	TRANS   PGPOLY
	TRANS   PGUPDT
	TRANS	PGDRAW      ; 1-05 29-Dec-1983
	TRANS	PGMOVE
	TRANS	PGHI2D      ; 1-06 21-Feb-1984
	TRANS   GRSCR
	TRANS   GRSETPEN    ; 1-07  6-Jun-1984
	TRANS	GRINQPEN
	TRANS   GRXHLS
	TRANS   GRXRGB
	TRANS   GRFA
	TRANS   GRRECT
	TRANS   PGLCUR
	TRANS   PGCONS      ; 1-08 27-Aug-1984
	TRANS   GRESC       ; 1-09 15-May-1985
	TRANS   PGSCI       ; 1-11 21-Oct-1985
        TRANS   PGSCF
        TRANS   PGSCH
	TRANS	PGSLS
	TRANS	PGSLW
        TRANS   PGSFS
	TRANS   PGWNAD      
        TRANS   PGQVP
        TRANS   PGQWIN
        TRANS   PGRND
        TRANS   PGIDEN
	TRANS   PGOLIN      ; 1-12  4-Nov-1985
        TRANS   PGQCF       ; 1-13  5-Nov-1985
	TRANS   PGQCH
	TRANS   PGQCI
	TRANS   PGQCR
	TRANS   PGQFS
	TRANS   PGQLS
	TRANS   PGQLW
	TRANS   PGSCR
	TRANS   PGRNGE
	TRANS   PGCONX      ; 1-14 18-Nov-1985
	TRANS	PGLDEV      ;      11-Sep-1986
	TRANS	PGQINF      ;      21-Nov-1986
	TRANS   PGRECT	    ;      21-Nov-1986
	TRANS   PGBBUF      ; 1-16 27-Nov-1986
	TRANS   PGEBUF      ;      27-Nov-1986
	TRANS	PGETXT      ; 1-47 18-Feb-1988
	TRANS	PGSHLS      ; 1-48  9-May-1988
	TRANS	PGPAGE
	TRANS	PGQCOL
	TRANS	PGCONB      ; v4.9A
	TRANS	PGTBOX      ; v4.9A
	TRANS	PGLEN       ; v4.9A
	TRANS	PGBEG       ; v4.9C
	TRANS	PGCURS      ; v4.9C
	TRANS	PGLAB       ; v4.9C
	TRANS	PGMTXT      ; v4.9C
	TRANS	PGNCUR      ; v4.9C
	TRANS	PGPAP       ; v4.9C
	TRANS	PGPT        ; v4.9C
	TRANS	PGPTXT      ; v4.9C
	TRANS	PGSVP       ; v4.9C
	TRANS	PGVSIZ      ; v4.9C
	TRANS	PGVSTD      ; v4.9C
	TRANS	PGSWIN      ; v4.9C
	TRANS	PGERRB	    ; v4.9D
	TRANS   PGPNTS	    ; v4.9D
	TRANS   PGQPOS	    ; v4.9D
	TRANS	PGPIXL	    ; v4.9D
	TRANS	PGARRO	    ; V4.9G
	TRANS	PGCIRC	    ; V4.9G
	TRANS	PGQAH 	    ; V4.9G
	TRANS	PGQVSZ	    ; V4.9G
	TRANS	PGSAH 	    ; V4.9G
	TRANS	PGSAVE	    ; V4.9G
	TRANS	PGUNSA	    ; V4.9G
	TRANS	PGVECT	    ; V4.9G
	TRANS	PGWEDG	    ; V4.9G
	TRANS	PGQCS	    ; V4.9G
	TRANS	PGSCRN	    ; V4.9G
	TRANS	GRSYXD	    ; 24-AUG-1993
	TRANS	PGQTXT	    ;  4-OCT-1993
	TRANS   PGSTBG	    ; 16-OCT-1993
	TRANS   PGQTBG	    ; 16-OCT-1993
	TRANS   PGSUBP      ; 15-NOV-1993
	TRANS	PGCONL      ; 2-SEP-1994
	TRANS	PGERAS      ; 2-SEP-1994
	TRANS	PGIMAG      ; 2-SEP-1994
	TRANS	PGSCIR      ; 2-SEP-1994
	TRANS	PGQCIR      ; 2-SEP-1994
	TRANS	PGBAND      ; 2-SEP-1994
	TRANS	PGCTAB      ; 8-SEP-1994
	TRANS	PGQITF	    ; 13-JAN-1995
	TRANS	PGSITF	    ; 13-JAN-1995
	TRANS	PGPANL	    ; 11-FEB-1995
	TRANS	PGQHS	    ; 26-FEB-1995
	TRANS	PGSHS	    ; 26-FEB-1995
	TRANS	PGOPEN	    ;  8-APR-1996
	TRANS	PGCLOS	    ;  8-APR-1996
	TRANS	PGSLCT	    ;  8-APR-1996
	TRANS	PGQID	    ;  8-APR-1996
	TRANS	PGAXIS	    ; v5.2.0 MAY-1997
	TRANS	PGCONF	    ; v5.2.0 MAY-1997
	TRANS	PGERR1	    ; v5.2.0 MAY-1997
	TRANS	PGPT1	    ; v5.2.0 MAY-1997
	TRANS	PGSCLP	    ; v5.2.0 MAY-1997
	TRANS	PGQCLP	    ; v5.2.0 MAY-1997
	TRANS	PGQDT	    ; v5.2.0 MAY-1997
	TRANS	PGQNDT	    ; v5.2.0 MAY-1997
	TRANS	PGSCRL	    ; v5.2.0 MAY-1997
	TRANS	PGTICK	    ; v5.2.0 MAY-1997
;
	.END
$!
$! Use the linker to create the shareable image, including the
$! transfer vector defined above. It is linked /NOTRACEBACK to
$! allow it to be INSTALLed if desired.
$!
$ LINK/NOMAP-
      /NOUSER-
      /NOTRACEBACK-
      /SHARE=GRPSHR.EXE-
      GRPCKG.OLB/INCLUDE=GROPEN,GRPCKG.OLB/LIB,-
      SYS$INPUT/OPT'UIS''XLIB'
! The following defines the version number of the shareable image.
GSMATCH = LEQUAL,1,50
CLUSTER = $TRANS,,,GRPSHRTRN.OBJ
! The following PSECT list must include all the common-blocks
! declared in GRPCKG and PGPLOT.
PSECT = GRCM00 ,LCL,NOSHR
PSECT = GRCM01 ,LCL,NOSHR
PSECT = GRCS02 ,LCL,NOSHR
PSECT = GRSYMB ,LCL,NOSHR
PSECT = PGPLT1 ,LCL,NOSHR
PSECT = PGPLT2 ,LCL,NOSHR
PSECT = GRGICO ,LCL,NOSHR
$ SET FILE/PROTECTION=(S:RWED,O:RWED,G:RE,W:RE) GRPSHRTRN.OBJ;*
$ DELETE GRPSHRTRN.OBJ;*
$ GOTO DONE
$!----------------------------------------------------------------------
$! OpenVMS-AXP
$!----------------------------------------------------------------------
$AXP:
$ ON WARNING THEN EXIT
$ WRITE SYS$OUTPUT "Building PGPLOT shareable library for OpenVMS-AXP"
$!
$! Use the linker to create the shareable image, including the
$! transfer vector. It is linked /NOTRACEBACK to allow it to be INSTALLed 
$! if desired.
$!
$ LINK/NOMAP-
      /NOUSER-
      /NOTRACEBACK-
      /SHARE=GRPSHR.EXE-
      GRPCKG.OLB/INCLUDE=GROPEN,GRPCKG.OLB/LIB,-
      SYS$INPUT/OPT'XLIB'
! The following defines the version number of the shareable image.
GSMATCH = LEQUAL,1,50
! The following PSECT list must include all the common-blocks
! declared in GRPCKG and PGPLOT.
PSECT = GRCM00 ,LCL,NOSHR
PSECT = GRCM01 ,LCL,NOSHR
PSECT = GRCS02 ,LCL,NOSHR
PSECT = GRSYMB ,LCL,NOSHR
PSECT = PGPLT1 ,LCL,NOSHR
PSECT = PGPLT2 ,LCL,NOSHR
PSECT = GRGICO ,LCL,NOSHR
! Transfer vectors: Only user-callable routines have transfer vectors.
! If you change this file and want it to be compatible with a previous
! version, you must add transfer vectors only at the end of the list.
! If you remove a transfer vector, replace it with a pointer to an
! error processing routine. 
SYMBOL_VECTOR=(GRAREA=PROCEDURE,-
GRCHAR=PROCEDURE,-
GRCHSZ=PROCEDURE,-
GRCLOS=PROCEDURE,-
GRCURS=PROCEDURE,-
GRETXT=PROCEDURE,-
GRQCI=PROCEDURE,-
GRQDT=PROCEDURE,-
GRQFNT=PROCEDURE,-
GRINQLI=PROCEDURE,-
GRQLS=PROCEDURE,-
GRQLW=PROCEDURE,-
GRQTYP=PROCEDURE,-
GRLINA=PROCEDURE,-
GRLINR=PROCEDURE,-
GRMARK=PROCEDURE,-
GRMOVA=PROCEDURE,-
GRMOVR=PROCEDURE,-
GROPEN=PROCEDURE,-
GRPAGE=PROCEDURE,-
GRMKER=PROCEDURE,-
GRSLCT=PROCEDURE,-
GRSETC=PROCEDURE,-
GRSCI=PROCEDURE,-
GRSFNT=PROCEDURE,-
GRSETLI=PROCEDURE,-
GRSLS=PROCEDURE,-
GRSLW=PROCEDURE,-
GRSETS=PROCEDURE,-
GRSIZE=PROCEDURE,-
GRCHKT=PROCEDURE,-
GRTERM=PROCEDURE,-
GRTEXT=PROCEDURE,-
GRTRAN=PROCEDURE,-
GRVECT=PROCEDURE,-
PGADVANCE=PROCEDURE,-
PGASK=PROCEDURE,-
PGBEGIN=PROCEDURE,-
PGBIN=PROCEDURE,-
PGBOX=PROCEDURE,-
PGCNSC=PROCEDURE,-
PGCONT=PROCEDURE,-
PGCURSE=PROCEDURE,-
PGEND=PROCEDURE,-
PGENV=PROCEDURE,-
PGERRX=PROCEDURE,-
PGERRY=PROCEDURE,-
PGGRAY=PROCEDURE,-
PGHIST=PROCEDURE,-
PGLABEL=PROCEDURE,-
PGLINE=PROCEDURE,-
PGMTEXT=PROCEDURE,-
PGNCURSE=PROCEDURE,-
PGPOINT=PROCEDURE,-
PGSETC=PROCEDURE,-
PGSIZE=PROCEDURE,-
PGTEXT=PROCEDURE,-
PGVPORT=PROCEDURE,-
PGVSIZE=PROCEDURE,-
PGVSTAND=PROCEDURE,-
PGWINDOW=PROCEDURE,-
PGPAPER=PROCEDURE,-
PGPTEXT=PROCEDURE,-
PGFUNT=PROCEDURE,-
PGFUNX=PROCEDURE,-
PGFUNY=PROCEDURE,-
PGNUMB=PROCEDURE,-
PGPOLY=PROCEDURE,-
PGUPDT=PROCEDURE,-
PGDRAW=PROCEDURE,-
PGMOVE=PROCEDURE,-
PGHI2D=PROCEDURE,-
GRSCR=PROCEDURE,-
GRSETPEN=PROCEDURE,-
GRINQPEN=PROCEDURE,-
GRXHLS=PROCEDURE,-
GRXRGB=PROCEDURE,-
GRFA=PROCEDURE,-
GRRECT=PROCEDURE,-
PGLCUR=PROCEDURE,-
PGCONS=PROCEDURE,-
GRESC=PROCEDURE,-
PGSCI=PROCEDURE,-
PGSCF=PROCEDURE,-
PGSCH=PROCEDURE,-
PGSLS=PROCEDURE,-
PGSLW=PROCEDURE,-
PGSFS=PROCEDURE,-
PGWNAD=PROCEDURE,-
PGQVP=PROCEDURE,-
PGQWIN=PROCEDURE,-
PGRND=PROCEDURE,-
PGIDEN=PROCEDURE,-
PGOLIN=PROCEDURE,-
PGQCF=PROCEDURE,-
PGQCH=PROCEDURE,-
PGQCI=PROCEDURE,-
PGQCR=PROCEDURE,-
PGQFS=PROCEDURE,-
PGQLS=PROCEDURE,-
PGQLW=PROCEDURE,-
PGSCR=PROCEDURE,-
PGRNGE=PROCEDURE,-
PGCONX=PROCEDURE,-
PGLDEV=PROCEDURE,-
PGQINF=PROCEDURE,-
PGRECT=PROCEDURE,-
PGBBUF=PROCEDURE,-
PGEBUF=PROCEDURE,-
PGETXT=PROCEDURE,-
PGSHLS=PROCEDURE,-
PGPAGE=PROCEDURE,-
PGQCOL=PROCEDURE,-
PGCONB=PROCEDURE,-
PGTBOX=PROCEDURE,-
PGLEN=PROCEDURE,-
PGBEG=PROCEDURE,-
PGCURS=PROCEDURE,-
PGLAB=PROCEDURE,-
PGMTXT=PROCEDURE,-
PGNCUR=PROCEDURE,-
PGPAP=PROCEDURE,-
PGPT=PROCEDURE,-
PGPTXT=PROCEDURE,-
PGSVP=PROCEDURE,-
PGVSIZ=PROCEDURE,-
PGVSTD=PROCEDURE,-
PGSWIN=PROCEDURE,-
PGERRB=PROCEDURE,-
PGPNTS=PROCEDURE,-
PGQPOS=PROCEDURE,-
PGPIXL=PROCEDURE,-
PGARRO=PROCEDURE,-
PGCIRC=PROCEDURE,-
PGQAH=PROCEDURE,-
PGQVSZ=PROCEDURE,-
PGSAH=PROCEDURE,-
PGSAVE=PROCEDURE,-
PGUNSA=PROCEDURE,-
PGVECT=PROCEDURE,-
PGWEDG=PROCEDURE,-
PGQCS=PROCEDURE,-
PGSCRN=PROCEDURE,-
GRSYXD=PROCEDURE,-
PGQTXT=PROCEDURE,-
PGSTBG=PROCEDURE,-
PGQTBG=PROCEDURE,-
PGSUBP=PROCEDURE,-
PGCONL=PROCEDURE,-
PGERAS=PROCEDURE,-
PGIMAG=PROCEDURE,-
PGSCIR=PROCEDURE,-
PGQCIR=PROCEDURE,-
PGBAND=PROCEDURE,-
PGCTAB=PROCEDURE,-
PGQITF=PROCEDURE,-
PGSITF=PROCEDURE,-
PGPANL=PROCEDURE,-
PGQHS=PROCEDURE,-	
PGSHS=PROCEDURE,-
PGOPEN=PROCEDURE,-
PGCLOS=PROCEDURE,-
PGSLCT=PROCEDURE,-
PGQID=PROCEDURE,-
PGAXIS=PROCEDURE,-
PGCONF=PROCEDURE,-
PGERR1=PROCEDURE,-
PGPT1=PROCEDURE,-
PGSCLP=PROCEDURE,-
PGQCLP=PROCEDURE,-
PGQDT=PROCEDURE,-
PGQNDT=PROCEDURE,-
PGSCRL=PROCEDURE,-
PGTICK=PROCEDURE-
)
$ GOTO DONE
$!----------------------------------------------------------------------
$DONE:
$ SET FILE/PROTECTION=(S:RWED,O:RWED,G:RE,W:RE) GRPSHR.EXE;*
$ PURGE GRPSHR.EXE
$ DELETE UIS.OPT;*,XLIB.OPT;*
$!
$! Create a Shareable Image Symbol Table Library to contain the
$! symbol table for GRPCKG; this library (GRPSHR.OLB) should be
$! linked with the user's program in place of the object-module
$! library (GRPCKG.OLB) in order to use the shareable image.
$!
$ LIBRARY/CREATE=(BLOCKS:12,MODULES:1)/SHARE GRPSHR.OLB GRPSHR.EXE
$ PURGE GRPSHR.OLB
$ SET FILE/PROTECTION=(S:RWED,O:RWED,G:RE,W:RE) GRPSHR.OLB
$ DEFINE/NOLOG GRPSHR 'F$SEARCH("GRPSHR.EXE")'
