/*
    Copyright (c) University of Manchester, 2006-November-17
 */
#define _GNU_SOURCE
#include <features.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <unistd.h>
#include <errno.h>
#include <fcntl.h>
#include <pwd.h>
#include <netinet/in.h>
#include <sys/ioctl.h>
#include <kafs.h>
#include <afs/stds.h>
#include <afs/auth.h>
#include <afs/afsint.h>
#define rc u_t_rc

/* AFS-specific functions not declared in any include file */

extern int ktc_SetToken(struct ktc_principal *server, struct ktc_token *token,
                        struct ktc_principal *client, afs_int32 flags);

#define PW_BUF_SIZE	1024
#define USER_NAME_LEN	17
#define MAX_RETRIES	6
#define MAIL_DIR	".Mail"
#define AFSMAIL_DIR	"/local/packages/afsmail/etc"
#define AFSMAIL_PW	"/local/packages/afsmail/etc/passwd"

int lockfp = 0;
char lockfile[USER_NAME_LEN + 5],
	thisname[USER_NAME_LEN + 2] = "unknown";
char *boxname = thisname;

/* rc -- exit(1) after writing an error message if a condition is not 0. */

void rc(long code, char *mesg)
{
  if (!code) return;
  fprintf(stderr, "Aborting (code %ld: %s: %s.)\n", code, thisname, mesg);
  if (lockfp > 0) {
    if (!close(lockfp))
      fprintf(stderr, "Closing %s fails with error %d.\n", lockfile, errno);
    if (!unlink(lockfile))
      fprintf(stderr, "Deleting %s fails with error %d.\n", lockfile, errno);
  }
  if (code == 0300) exit(code);
  else exit(0200);
}

void bounce(long code, char *mesg)	/* Failure should cause the message
					   to be returned to the sender */
{
  if (!code) return;
  rc(0300, mesg);
}

int remove_symlink(char *name)	/* return 1 if exists and is not dir */
{
  struct stat sb;
  struct ViceIoctl data;

  if (lstat(name, &sb))
    return(0);		/* Does not exist, or is off line */
  if (!S_ISLNK(sb.st_mode)) {	/* Is not a link */
    if (!S_ISDIR(sb.st_mode))
      return(1);		/* Return true if not a dir */
    data.in = name;
    data.in_size = strlen(name) + 1;
    data.out = NULL;
    data.out_size = 0;
    if (k_pioctl(".", VIOC_AFS_STAT_MT_PT, &data, 1))
      return(0);
  }
  rc(unlink(name), "Can't delete illegal link or mount point");
  return(0);
}

void main(int count, char **vector)
{
  int iterate, fd;
  FILE *fp;
  uid_t idno;
  gid_t grno;
  char	buffer[PW_BUF_SIZE],
	maildir[PW_BUF_SIZE];

  if ((count != 4) && (count != 5)) {
    fprintf(stderr, "Usage: %s destination source size\n", *vector);
    exit(2);
  }

  if (count == 5) boxname = "spam";
  chdir(AFSMAIL_DIR);

/* Create an authentication group to isolate this 'family' of processes. */

  rc(!k_hasafs(), "This is not an AFS machine");
  k_setpag();

/* Recover a saved admin token, and activate it.  These tokens are
   saved by another program every 8 hours, and have 25 hour duration. */

  rc(EOF == (fd = open(TOKEN_FILE, O_RDONLY)), "Can't open token file");

  {
	struct ktc_principal serviceName, clientName;
	struct ktc_token token;

	read(fd, (char *)&serviceName, sizeof(serviceName));
	read(fd, (char *)&token, sizeof(token));
	read(fd, (char *)&clientName, sizeof(clientName));
	close(fd);

	rc(ktc_SetToken(&serviceName, &token, &clientName, 0),
		"Can't set token");
  }

  {
    int  namelen;
    char *idpos, *grouppos, *homedpos, *termpos;

/* I need this section because most incoming mail is for people not
   in the local passwd file. */

    strncpy(thisname, vector[1], USER_NAME_LEN);
    strcat(thisname, ":");
    namelen = strlen(thisname);
    rc(!(fp = fopen(AFSMAIL_PW, "r")), "Can't open passwd file");
    do
      if (!fgets(buffer, PW_BUF_SIZE, fp))
	rc(1, "Can't find addressee in passwd file");
    while (strncmp(thisname, buffer, namelen));
    fclose(fp);

    thisname[namelen - 1] = '\0';
    rc(!(idpos = strchr(buffer + namelen, ':')) ||
       !(grouppos = strchr(++idpos, ':')) ||
       !(homedpos = strchr(++grouppos, ':')) ||
       !(homedpos = strchr(homedpos + 1, ':')) ||
       !(termpos = strchr(++homedpos, ':')), "Bad password entry");
    *termpos = '\0';

    rc(setgid(grno = atoi(grouppos)), "Unable to set gid");
    rc(setuid(idno = atoi(idpos)), "Unable to set uid");

/* Change the home directories, especially for those users outside
   of AFS, to a pseudo-home in AFS. */

    if (!strncmp(homedpos, "/home/", 6))
      sprintf(maildir, "/afs/mcc/users%s", homedpos + 5);
    else if (!strncmp(homedpos, "/users3/dbase/dbusers/", 22))
      sprintf(maildir, "/afs/mcc/users/mbj%s", homedpos + 21);
    else if (!strncmp(homedpos, "/local/home/", 12))
      sprintf(maildir, "/afs/mcc/users/mcc%s", homedpos + 11);
    else if (!strncmp(homedpos, "/usr/users/", 11) ||
	     !strncmp(homedpos, "/usr/local/", 11))
      sprintf(maildir, "/afs/mcc/users/mcc%s", homedpos + 10);
    else if (!strncmp(homedpos, "/users2/", 8))
      sprintf(maildir, "/afs/mcc/users/mcc%s", homedpos + 7);
    else rc(1, "Unrecognizable home directory");
    rc(chdir(maildir), "Unable to chdir to home directory");
  }

/* Ensure that the destination volume has enough space to receive
   the mail, and bounce it if it doesn't. */

  {
    struct ViceIoctl data;
    char b[sizeof(VolumeStatus) + 1024];
    VolumeStatus *status = (VolumeStatus *) b;
    unsigned int size;

    size = (atoi(vector[3]) + 1023) / 1024;
    data.in_size = 0;
    data.out_size = sizeof(b);
    data.out = b;
    k_pioctl(".", VIOCGETVOLSTAT, &data, 1);
    bounce(status->BlocksInUse + size + 2 >= status->MaxQuota,
      "Unable to deliver mail; volume is too full");
  }

/* Create a .Mail directory if necessary. */

  if (remove_symlink(MAIL_DIR))
    rc(unlink(MAIL_DIR), "Can't delete illegal mail directory");
  if (chdir(MAIL_DIR)) {
    rc(mkdir(MAIL_DIR, 0711), "Unable to mkdir .Mail; possible quota problem");
    chown(MAIL_DIR, idno, grno);
    sprintf(maildir, "/usr/afsws/bin/fs sa .Mail -acl "
	"system:administrators all %s all -clear", thisname);
    system(maildir);
    rc(chdir(MAIL_DIR), "Unable to chdir to .Mail");
  }

/* Create a lock file, retrying MAX_RETRIES times, waiting 10 seconds */

  sprintf(lockfile, "%s.lock", boxname);
  iterate = MAX_RETRIES;
  while (1) {
    errno = 0;
    if ((lockfp = open(lockfile, O_WRONLY | O_CREAT | O_EXCL, 0444)) != -1)
	break;
    rc(errno != EEXIST, "Unable to create lock file; possible quota problem");
    if (!--iterate) {
      time_t now;
      struct stat sb;

      time(&now);
      rc(lstat(lockfile, &sb), "Unable to lstat lockfile");
      if (now - sb.st_ctime > 3600) {
	unlink(lockfile);
	exit(1);
      }
      rc(1, "Lock file exists for more than 2 minutes");
    }
    sleep(10);
  }

/* Format the date and time for the From line. */

  {
    time_t now;

    time(&now);
    strftime(buffer, PW_BUF_SIZE, "%a %b %d %H:%M %Z %Y", localtime(&now));
  }
  remove_symlink(boxname);		/* Delete symbolic link */
  rc(!(fp = fopen(boxname, "a")), "Unable to open mail folder");
  fprintf(fp, "\01\01\01\01\nFrom %s %s\n", vector[2], buffer);

/* Copy from stdin to the mail folder. */

  while(fgets(buffer, PW_BUF_SIZE, stdin))
    fputs(buffer, fp);
  fputs("\01\01\01\01\n", fp);
  iterate = MAX_RETRIES;
  while(1) {
    if (!fclose(fp))
      break;
    rc(!--iterate, "Unable to close mail folder");
    sleep(10);
  }

  chown(boxname, idno, grno);
  chmod(boxname, 0600);
  close(lockfp);
  unlink(lockfile);
  exit(0);
}
