%% Generated by lilypond-book.py
%% Options: [exampleindent=10.16\mm,indent=0\mm,line-width=160\mm]
\include "lilypond-book-preamble.ly"


% ****************************************************************
% Start cut-&-pastable-section
% ****************************************************************



\paper {
  indent = 0\mm
  line-width = 160\mm
  % offset the left padding, also add 1mm as lilypond creates cropped
  % images with a little space on the right
  line-width = #(- line-width (* mm  3.000000) (* mm 1))
}

\layout {
  
}





% ****************************************************************
% ly snippet:
% ****************************************************************
\sourcefilename "adding-indicators-to-staves-which-get-split-after-a-break.ly"
\sourcefileline 0
%% DO NOT EDIT this file manually; it is automatically
%% generated from LSR http://lsr.dsi.unimi.it
%% Make any changes in LSR itself, or in Documentation/snippets/new/ ,
%% and then run scripts/auxiliar/makelsr.py
%%
%% This file is in the public domain.
\version "2.16.0"

\header {
%% Translation of GIT committish: cc3b9e1430f4cc9c54da7252e504f3d274a7ea17
  texidocfr = "
Dans cet extrait est définie la commande @code{\\splitStaffBarLine} qui
ajoute une double flèche après la dernière barre de mesure d'une portée,
indiquant par là que ses différentes voix disposeront de leur propre
portée à la ligne suivante.

"
  doctitlefr = "Ajout d'indicateurs à une portée dédoublée après un saut de ligne"

  lsrtags = "staff-notation, symbols-and-glyphs, vocal-music"

  texidoc = "
This snippet defines the @code{\\splitStaffBarLine} command, which adds
arrows in north-east and south-east directions at a bar line, to denote
that several voices sharing a staff will each continue on a staff of
their own in the next system.

"
  doctitle = "Adding indicators to staves which get split after a break"
} % begin verbatim

#(define-markup-command (arrow-at-angle layout props angle-deg length fill)
   (number? number? boolean?)
   (let* (
          ;; PI-OVER-180 and degrees->radians are taken from flag-styles.scm
          (PI-OVER-180 (/ (atan 1 1) 45))
          (degrees->radians (lambda (degrees) (* degrees PI-OVER-180)))
          (angle-rad (degrees->radians angle-deg))
          (target-x (* length (cos angle-rad)))
          (target-y (* length (sin angle-rad))))
     (interpret-markup layout props
                       (markup
                        #:translate (cons (/ target-x 2) (/ target-y 2))
                        #:rotate angle-deg
                        #:translate (cons (/ length -2) 0)
                        #:concat (#:draw-line (cons length 0)
                                              #:arrow-head X RIGHT fill)))))

splitStaffBarLineMarkup = \markup \with-dimensions #'(0 . 0) #'(0 . 0) {
  \combine
    \arrow-at-angle #45 #(sqrt 8) ##f
    \arrow-at-angle #-45 #(sqrt 8) ##f
}

splitStaffBarLine = {
  \once \override Staff.BarLine #'stencil =
    #(lambda (grob)
       (ly:stencil-combine-at-edge
        (ly:bar-line::print grob)
        X RIGHT
        (grob-interpret-markup grob splitStaffBarLineMarkup)
        0))
  \break
}

\paper {
  ragged-right = ##t
  short-indent = 5\mm
}

\score {
  <<
    \new ChoirStaff <<
      \new Staff \with { instrumentName = #"High I + II" } {
        <<
          \repeat unfold 4 f''1
          \\
          \repeat unfold 4 d''1
        >>
        \splitStaffBarLine
      }
      \new Staff \with { instrumentName = #"Low" } {
        <<
          \repeat unfold 4 b'1
          \\
          \repeat unfold 4 g'1
        >>
      }

      \new Staff \with { shortInstrumentName = #"H I" } {
        R1*4
        \repeat unfold 2 { r4 f''2 r4 } \repeat unfold 2 e''1
      }
      \new Staff \with { shortInstrumentName = #"H II" } {
        R1*4
        \repeat unfold 4 b'2 \repeat unfold 2 c''1
      }
      \new Staff \with { shortInstrumentName = #"L" } {
        R1*4
        <<
          \repeat unfold 4 g'1
          \\
          \repeat unfold 4 c'1
        >>
      }
    >>
  >>
  \layout {
    \context {
      \Staff \RemoveEmptyStaves
      \override VerticalAxisGroup #'remove-first = ##t
    }
  }
}



% ****************************************************************
% end ly snippet
% ****************************************************************
