%% Generated by lilypond-book.py
%% Options: [exampleindent=10.16\mm,indent=0\mm,line-width=160\mm]
\include "lilypond-book-preamble.ly"


% ****************************************************************
% Start cut-&-pastable-section
% ****************************************************************



\paper {
  indent = 0\mm
  line-width = 160\mm
  % offset the left padding, also add 1mm as lilypond creates cropped
  % images with a little space on the right
  line-width = #(- line-width (* mm  3.000000) (* mm 1))
}

\layout {
  
}





% ****************************************************************
% ly snippet:
% ****************************************************************
\sourcefilename "rhythmic-slashes.ly"
\sourcefileline 0
%% DO NOT EDIT this file manually; it is automatically
%% generated from LSR http://lsr.dsi.unimi.it
%% Make any changes in LSR itself, or in Documentation/snippets/new/ ,
%% and then run scripts/auxiliar/makelsr.py
%%
%% This file is in the public domain.
\version "2.16.0"

\header {
%% Translation of GIT committish: cc3b9e1430f4cc9c54da7252e504f3d274a7ea17
  texidocfr = "
Il arrive, dans une feuille de chant « simple », que les notes soient
remplacées par une « pulsation » et que la structure de la chanson soit
indiquées par les accords au-dessus des mesures.  Ceci peut être utile
lorsque l'on crée ou retranscrit la structure d'une chanson, ainsi que
pour donner au guitariste et musiciens de jazz une pseudo partition.  Le
fonctionnement standard d'un @code{\\repeat percent} n'est pas ici
applicable puisque le premier temps doit être une note ou un silence.
Le code ci-dessous propose deux alternatives à ce problème en
redéfinissant l'aspect d'un silence.  Si la durée d'un temps ne
correspond pas à la noire, le @code{r4} inclus dans la définition devra
être remplacé par un silence de durée appropriée.

"
  doctitlefr = "Barres rythmiques"

  lsrtags = "rhythms, tweaks-and-overrides"

  texidoc = "
In @qq{simple} lead-sheets, sometimes no actual notes are written,
instead only @qq{rhythmic patterns} and chords above the measures are
notated giving the structure of a song. Such a feature is for example
useful while creating/transcribing the structure of a song and also
when sharing lead sheets with guitarists or jazz musicians. The
standard support for this using @code{\\repeat percent} is unsuitable
here since the first beat has to be an ordinary note or rest. This
example shows two solutions to this problem, by redefining ordinary
rests to be printed as slashes. (If the duration of each beat is not a
quarter note, replace the @code{r4} in the definitions with a rest of
the appropriate duration).

"
  doctitle = "Rhythmic slashes"
} % begin verbatim


% Macro to print single slash
rs = {
  \once \override Rest #'stencil = #ly:percent-repeat-item-interface::beat-slash
  \once \override Rest #'thickness = #0.48
  \once \override Rest #'slope = #1.7
  r4
}

% Function to print a specified number of slashes
comp = #(define-music-function (parser location count) (integer?)
  #{
    \override Rest #'stencil = #ly:percent-repeat-item-interface::beat-slash
    \override Rest #'thickness = #0.48
    \override Rest #'slope = #1.7
    \repeat unfold $count { r4 }
    \revert Rest #'stencil
  #}
)

\score {
  \relative c' {
    c4 d e f |
    \rs \rs \rs \rs |
    \comp #4 |
  }
}



% ****************************************************************
% end ly snippet
% ****************************************************************
