%% Generated by lilypond-book.py
%% Options: [exampleindent=10.16\mm,indent=0\mm,line-width=160\mm,quote]
\include "lilypond-book-preamble.ly"


% ****************************************************************
% Start cut-&-pastable-section
% ****************************************************************



\paper {
  indent = 0\mm
  line-width = 160\mm
  % offset the left padding, also add 1mm as lilypond creates cropped
  % images with a little space on the right
  line-width = #(- line-width (* mm  3.000000) (* mm 1))
  line-width = 160\mm - 2.0 * 10.16\mm
  % offset the left padding, also add 1mm as lilypond creates cropped
  % images with a little space on the right
  line-width = #(- line-width (* mm  3.000000) (* mm 1))
}

\layout {
  
}





% ****************************************************************
% ly snippet:
% ****************************************************************
\sourcefilename "time-signature-printing-only-the-numerator-as-a-number-instead-of-the-fraction.ly"
\sourcefileline 0
%% DO NOT EDIT this file manually; it is automatically
%% generated from LSR http://lsr.dsi.unimi.it
%% Make any changes in LSR itself, or in Documentation/snippets/new/ ,
%% and then run scripts/auxiliar/makelsr.py
%%
%% This file is in the public domain.
\version "2.16.0"

\header {
%% Translation of GIT committish: 596761e4a1c62fc2e85fe3396a378b814504e7b1
  texidoces = "

A veces, la indicación de compás no debe imprimir la fracción completa
(p.ej.  7/4), sino sólo el numerador (7 en este caso).  Esto se puede
hacer fácilmente utilizando @code{\\override Staff.TimeSignature
#'style = #'single-digit} para cambiar el estilo
permanentemente. Usando @code{\\revert Staff.TimeSignature #'style},
se puede revertir el cambio.  Para aplicar el estilo de un dígito
único a una sola indicación de compás, utilice la instrucción
@code{\\override} y anteponga la instrucción @code{\\once}.

"
  doctitlees = "Indicación de compás imprimiendo sólo el numerador (en lugar de la fracción)"

%% Translation of GIT committish: cc3b9e1430f4cc9c54da7252e504f3d274a7ea17
  texidocfr = "
La métrique est parfois indiquée non pas par une fraction (par ex. 7/4)
mais simplement par son numérateur (7 dans ce cas).  L'instruction
@code{\\override Staff.TimeSignature #'style = #'single-digit} permet de
déroger au style par défaut de manière permanente -- un @code{\\revert
Staff.TimeSignature #'style} annulera ces modifications.  Lorsque cette
métrique sous la forme d'un seul chiffre ne se présente qu'une seule
fois, il suffit de faire précéder l'instruction @code{\\override} d'un
simple @code{\\once}.

"
  doctitlefr = "Affichage seulement du numérateur d'une métrique (au lieu d'une fraction)"

  lsrtags = "rhythms, tweaks-and-overrides"

  texidoc = "
Sometimes, a time signature should not print the whole fraction (e.g.
7/4), but only the numerator (7 in this case). This can be easily done
by using @code{\\override Staff.TimeSignature #'style = #'single-digit}
to change the style permanently. By using @code{\\revert
Staff.TimeSignature #'style}, this setting can be reversed. To apply
the single-digit style to only one time signature, use the
@code{\\override} command and prefix it with a @code{\\once}.

"
  doctitle = "Time signature printing only the numerator as a number (instead of the fraction)"
} % begin verbatim


\relative c'' {
  \time 3/4
  c4 c c
  % Change the style permanently
  \override Staff.TimeSignature #'style = #'single-digit
  \time 2/4
  c4 c
  \time 3/4
  c4 c c
  % Revert to default style:
  \revert Staff.TimeSignature #'style
  \time 2/4
  c4 c
  % single-digit style only for the next time signature
  \once \override Staff.TimeSignature #'style = #'single-digit
  \time 5/4
  c4 c c c c
  \time 2/4
  c4 c
}



% ****************************************************************
% end ly snippet
% ****************************************************************
