%% Generated by lilypond-book.py
%% Options: [exampleindent=10.16\mm,indent=0\mm,line-width=160\mm]
\include "lilypond-book-preamble.ly"


% ****************************************************************
% Start cut-&-pastable-section
% ****************************************************************



\paper {
  indent = 0\mm
  line-width = 160\mm
  % offset the left padding, also add 1mm as lilypond creates cropped
  % images with a little space on the right
  line-width = #(- line-width (* mm  3.000000) (* mm 1))
}

\layout {
  
}





% ****************************************************************
% ly snippet:
% ****************************************************************
\sourcefilename "using-the-whiteout-property.ly"
\sourcefileline 0
%% DO NOT EDIT this file manually; it is automatically
%% generated from LSR http://lsr.dsi.unimi.it
%% Make any changes in LSR itself, or in Documentation/snippets/new/ ,
%% and then run scripts/auxiliar/makelsr.py
%%
%% This file is in the public domain.
\version "2.16.0"

\header {
%% Translation of GIT committish: 596761e4a1c62fc2e85fe3396a378b814504e7b1

  texidoces = "

Se puede imprimir cualquier objeto gráfico sobre un fondo blanco para
enmascarar parte de los objetos que están por debajo.  Esto puede ser
útil para mejorar el aspecto de las colisiones en situaciones
complejas cuando no es práctico reposicionar los objetos.  Es
necesario establecer explícitamente la propiedad de capa
(@code{layer}) para controlar qué objetos resultan enmascarados por el
fondo blanco.

En este ejemplo, la colisión de la ligadura de unión con la indicación
de compás resulta mejorada enmascarando la parte de la ligadura que
cruza a la indicación de compás mediante el establecimiento de la
propiedad @code{whiteout} de @code{TimeSignature}.  Para hacer esto,
se mueve @code{TimeSignature} a una capa por encima de @code{Tie}, que
se deja en la capa predeterminada de 1, y @code{StaffSymbol} se mueve
a una capa por encima de @code{TimeSignature} de manera que no resulte
enmascarada.

"

  doctitlees = "Uso de la propiedad whiteout"

%% Translation of GIT committish: cc3b9e1430f4cc9c54da7252e504f3d274a7ea17
  texidocfr = "
Tout objet graphique peut s'imprimer sur un fond blanc afin de masquer
une partie des objets qu'il recouvre.  Ceci trouve toute son utilité
pour améliorer certaines collisions, notamment dans des situations où un
repositionnement d'objets est irréaliste.  Il faut alors explicitement
définir la propriété @code{layer} afin de contrôler quels objets seront
masqués par le fond blanc.

Dans l'exemple ci-dessous, la liaison est en collision avec la
métrique ; la situation est améliorée dès lors que la portion de liaison
qui traverse la métrique est masquée par l'affectation de la propriété
@code{whiteout} à l'objet @code{TimeSignature}.  Pour ce faire,
@code{TimeSignature} est déplacé sur un calque au-dessus de celui de
@code{Tie} -- il reste sur le calque par défaut (1) --, puis le
@code{StaffSymbol} est placé sur un calque supérieur à celui de
@code{TimeSignature} pour ne pas être masqué.

"
  doctitlefr = "Utilisation de la propriété whiteout"

  lsrtags = "editorial-annotations, expressive-marks"

  texidoc = "
Any graphical object can be printed over a white background to mask
parts of objects that lie beneath.  This can be useful to improve the
appearance of collisions in complex situations when repositioning
objects is impractical.  It is necessary to explicitly set the
@code{layer} property to control which objects are masked by the white
background.

In this example the collision of the tie with the time signature is
improved by masking out the part of the tie that crosses the time
signature by setting the @code{whiteout} property of
@code{TimeSignature}. To do this @code{TimeSignature} is moved to a
layer above @code{Tie}, which is left in the default layer of 1, and
@code{StaffSymbol} is moved to a layer above @code{TimeSignature} so it
is not masked.

"
  doctitle = "Using the whiteout property"
} % begin verbatim

{
  \override Score.StaffSymbol #'layer = #4
  \override Staff.TimeSignature #'layer = #3
  b'2 b'~
  \once \override Staff.TimeSignature #'whiteout = ##t
  \time 3/4
  b' r4
}



% ****************************************************************
% end ly snippet
% ****************************************************************
