%% Generated by lilypond-book.py
%% Options: [exampleindent=10.16\mm,indent=0\mm,line-width=160\mm]
\include "lilypond-book-preamble.ly"


% ****************************************************************
% Start cut-&-pastable-section
% ****************************************************************



\paper {
  indent = 0\mm
  line-width = 160\mm
  % offset the left padding, also add 1mm as lilypond creates cropped
  % images with a little space on the right
  line-width = #(- line-width (* mm  3.000000) (* mm 1))
}

\layout {
  
}





% ****************************************************************
% ly snippet:
% ****************************************************************
\sourcefilename "/main/src/gub/target/linux-x86/src/lilypond-git.sv.gnu.org--lilypond.git-stable-2.16/input/regression/quote-during-subvoice.ly"
\sourcefileline 0
\version "2.16.0"

\header {
  texidoc = "@code{\\quoteDuring} and @code{\\cueDuring} shall properly quote
voices that create a sub-voice.  The sub-voice will not be quoted, though.
Exceptions are sections of parallel music @code{<< @{...@} \\ @{...@} >>},
which will be quoted.
"
}

% Simple case, normal sub-voice
quoteMe = \relative c' {
  c4 c
  \new Voice {
    c4 c
  }
}
\addQuote "quoteMe" \quoteMe
% Also works if wrapped with \new Voice
\addQuote "quoteMeA" \new Voice \quoteMe

% Also works with voice directly inside relative
quoteMeI = \relative c' \new Voice {
  c4 c4
}
\addQuote "quoteMeI" \quoteMeI

% Quoting music with some parallel sections (identical rhythm)
quoteMeII = \relative c' {
  c4 c
  << { d4 e4 } \\ { c4 b4 } >>
  c4
}
\addQuote "quoteMeII" \quoteMeII

% Quoting music with some parallel sections (different rhythm)
quoteMeIII = \relative c' {
  c4 c
  << { d4 e4 } \\ { c4. b8 } >>
  c4
}
\addQuote "quoteMeIII" \quoteMeIII




<<
  \new Staff \relative c'' {
    c4 \cueDuring #"quoteMe" #DOWN { r4 }
    c4 \cueDuring #"quoteMe" #DOWN { r4 } % <- no cue note due to sub-voice
  }
  \new Staff \relative c'' {
    c4 \cueDuring #"quoteMeA" #DOWN { r4 }
    c4 \cueDuring #"quoteMeA" #DOWN { r4 } % <- no cue note due to sub-voice
  }
  \new Staff \relative c'' {
    c4 \cueDuring #"quoteMeI" #DOWN { r4 }
    c4
  }
  \new Staff \relative c'' {
    c4 \cueDuring #"quoteMeII" #DOWN { r4 }
    c4 \cueDuring #"quoteMeII" #DOWN { r4 } % <- quoted parallel notes
  }
  \new Staff \relative c'' {
    c4 \cueDuring #"quoteMeIII" #DOWN { r4 }
    c4 \cueDuring #"quoteMeIII" #DOWN { r4 } % <- quoted parallel notes
  }
>>



% ****************************************************************
% end ly snippet
% ****************************************************************
