# Copyright (C) 2020-2022 Musarubra US LLC. All Rights Reserved.
# RPM spec file used to create a unified RPM package which ships SELinux policies for RHEL 7, RHEL 8, RHEL 9
%global ens_selinux_prod_name McAfeeENS-selinux
%global bld_version 10.7.12
%global selinux_variants targeted
# For custom builds min and max version will be unused, it is unused only for build room builds
%global min_selinux_policy_version_supported 34.1.29-1
%global max_selinux_policy_version_supported Unknown
%global ens_root_dir /opt/McAfee/ens
%global ens_var_dir /var/McAfee/ens
%global ens_selinux_root_dir /opt/McAfee/ens/selinux
%global ens_selinux_var_dir /var/McAfee/ens/selinux
%global ens_esp_control_script /opt/McAfee/ens/esp/init/mfeespd-control.sh
%global ens_tp_control_script /opt/McAfee/ens/tp/init/mfetpd-control.sh
%global ens_fw_control_script /opt/McAfee/ens/fw/init/mfefwd-control.sh
# The optional tag restrict_policy_load is disabled for custom builds and enabled only for build room builds
# The optional tag multiple_policies is disabled for custom builds and enabled only for build room builds
# List of SELinux policies. This sequence will also be used to load the policies
%global module_name_list mfe_ens_rt mfe_ens_esp mfe_ens_fw mfe_ens_tp
# List of SELinux policies used to only unload SELinux policies in sequence.
%global module_name_unload_list mfe_ens_tp mfe_ens_fw mfe_ens_esp mfe_ens_rt

Name:               %{ens_selinux_prod_name}
Version:            %{bld_version}
Release:            %{pkg_version}%{?dist}
BuildArch:          noarch
Summary:            SELinux policies for Trellix Endpoint Security for Linux
License:            Proprietary
BuildRoot:          %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
Source0:            %{ens_selinux_prod_name}/%{ens_selinux_prod_name}%{?dist}.tar.gz
Requires:           /usr/sbin/semodule, /sbin/restorecon
%if 0%{?restrict_policy_load} == 1

# For el9, minimum supported version is 34.1.29-1 which is shipped by RHEL 9.0
%if %{_rhel} == 9
Requires:           selinux-policy >= %{min_selinux_policy_version_supported}
%else
# For el7, minimum supported version is 3.13.1-23 which is shipped by RHEL 7.1 and max supported is 3.14.1-61 which is shipped by RHEL 8.0
Requires:           selinux-policy >= %{min_selinux_policy_version_supported}, selinux-policy < %{max_selinux_policy_version_supported}
%endif
%endif
# Policies are supported for a specific version and conflicts with ENSL runtime for any other versions
Conflicts:          McAfeeRt < 10.7.0
Conflicts:          McAfeeRt >= 10.8.0

Source1:            %{ens_selinux_prod_name}/src/mfe_ens_perm.if
Source2:            %{ens_selinux_prod_name}/src/mfe_ens_rt.fc
Source3:            %{ens_selinux_prod_name}/src/mfe_ens_rt.if
Source4:            %{ens_selinux_prod_name}/src/mfe_ens_rt.te
Source5:            %{ens_selinux_prod_name}/src/mfe_ens_esp.fc
Source6:            %{ens_selinux_prod_name}/src/mfe_ens_esp.if
Source7:            %{ens_selinux_prod_name}/src/mfe_ens_esp.te
Source8:            %{ens_selinux_prod_name}/src/mfe_ens_tp.fc
Source9:            %{ens_selinux_prod_name}/src/mfe_ens_tp.if
Source10:           %{ens_selinux_prod_name}/src/mfe_ens_tp.te
Source11:           %{ens_selinux_prod_name}/src/mfe_ens_fw.fc
Source12:           %{ens_selinux_prod_name}/src/mfe_ens_fw.if
Source13:           %{ens_selinux_prod_name}/src/mfe_ens_fw.te
Source14:           %{ens_selinux_prod_name}/src/Makefile
Source15:           %{ens_selinux_prod_name}/src/license.txt
Source16:           %{ens_selinux_prod_name}/src/README.md

%description
SELinux policies for Trellix Endpoint Security for Linux 10.7.13 and above

%prep
# Remove -q to get verbose output
%setup -c -q
set +x
%if 0%{?multiple_policies} == 1
# Copy all compiled policies from %{_topdir}/SOURCES/%{ens_selinux_prod_name}
# They are kept inside folder selinux-<policyversion>
# rpmbuild will fail if no compiled policy folder is found
foundPolicy=0
for f in %{_topdir}/SOURCES/%{ens_selinux_prod_name}/selinux-*/
do
    [ ! -d "${f}" ] && continue
    cp -rvf ${f} %{ens_selinux_prod_name}
    foundPolicy=1
done
if [ "${foundPolicy}" = 0 ]
then
    echo "rpmbuild is failing as no SELinux policies were found in %{_topdir}/SOURCES/%{ens_selinux_prod_name}/"
    exit 1
fi
%else
# Copy all compiled policies from %{_topdir}/SOURCES/%{ens_selinux_prod_name}
# rpmbuild will fail if no compiled policy is found
foundPolicy=1
for selinuxvariant in %{selinux_variants}
do
    for module_name in %{module_name_list}
    do
        if [ -f %{_topdir}/SOURCES/%{ens_selinux_prod_name}/${module_name}.pp.${selinuxvariant} ]
        then
            cp -vf %{_topdir}/SOURCES/%{ens_selinux_prod_name}/${module_name}.pp.${selinuxvariant} %{ens_selinux_prod_name}
        else
            echo "ERROR: Please copy ${module_name}.pp.${selinuxvariant} to %{_topdir}/SOURCES/%{ens_selinux_prod_name}/"
            foundPolicy=0
        fi
    done
done
if [ "${foundPolicy}" = 0 ]
then
    echo "rpmbuild is failing as SELinux policies were not found in %{_topdir}/SOURCES/%{ens_selinux_prod_name}/"
    exit 1
fi
%endif
cp -rv %{_topdir}/SOURCES/%{ens_selinux_prod_name}/license.txt  %{ens_selinux_prod_name}

%install
rm -rf %{buildroot}
cd %{ens_selinux_prod_name}
# Copy all SELinux policy files
# SELinux policy files are not hard-coded in the spec file, instead pick from an external file
rm -f files.lst
for selinuxvariant in %{selinux_variants}
do
%if 0%{?multiple_policies} == 1
    for selinuxpolicyversion in %{_ens_selinux_policy_version_list}
    do
        for module_name in %{module_name_list}
        do
            install -d %{buildroot}/%{ens_selinux_var_dir}/${selinuxvariant}/selinux-${selinuxpolicyversion}
            install -p -m 644 selinux-${selinuxpolicyversion}/${module_name}.pp.${selinuxvariant} \
                %{buildroot}/%{ens_selinux_var_dir}/${selinuxvariant}/selinux-${selinuxpolicyversion}/${module_name}.pp
            echo "%{ens_selinux_var_dir}/${selinuxvariant}/selinux-${selinuxpolicyversion}/${module_name}.pp" >> files.lst
        done
    done
%else
    for module_name in %{module_name_list}
    do
        install -d %{buildroot}/%{ens_selinux_var_dir}/${selinuxvariant}
        install -p -m 644 ${module_name}.pp.${selinuxvariant} \
            %{buildroot}/%{ens_selinux_var_dir}/${selinuxvariant}/${module_name}.pp
        echo "%{ens_selinux_var_dir}/${selinuxvariant}/${module_name}.pp" >> files.lst
    done
%endif
done
# Copy custom script file
install -d %{buildroot}/%{ens_selinux_root_dir}/scripts
install -p -m 755 scripts/update-selinux-context.sh %{buildroot}/%{ens_selinux_root_dir}/scripts/update-selinux-context.sh
# Copy License file
install -p -m 644 license.txt %{buildroot}/%{ens_selinux_root_dir}/license.txt
cd -

%clean
rm -rf %{buildroot}

%pre
installType=$1
# Compares two versions a and b and return its value. Both should be in 10.2.2.1105 format
# Returns 1 for more (a > b), 2 for less (a < b) and 0 for equal version (a == b)
function vercomp () {
    if [[ $1 == $2 ]]
    then
        return 0
    fi
    a=$1
    b=$2
    a=$(echo ${a}| sed 's/-/./')
    b=$(echo ${b} | sed 's/-/./')
    local IFS=.
    local i ver1=($a) ver2=($b)
    # fill empty fields in ver1 with zeros
    for ((i=${#ver1[@]}; i<${#ver2[@]}; i++))
    do
        ver1[i]=0
    done
    for ((i=0; i<${#ver1[@]}; i++))
    do
        if [[ -z ${ver2[i]} ]]
        then
            # fill empty fields in ver2 with zeros
            ver2[i]=0
        fi
        if ((10#${ver1[i]} > 10#${ver2[i]}))
        then
            return 1
        fi
        if ((10#${ver1[i]} < 10#${ver2[i]}))
        then
            return 2
        fi
    done
    return 0
}
case "${installType}" in
    1)  # Install
        distribRelString="Unknown"
        if [ -f "/etc/redhat-release" ]
        then
            distribRel=$(cat /etc/redhat-release)
        elif [ -f "/etc/system-release" ]
        then
            distribRel=$(cat /etc/system-release)
        elif [ -f "/etc/SuSE-release" ]
        then
            # Need only the first line
            distribRel=$(head -n 1 /etc/SuSE-release)
        elif [ -f "/etc/os-release" ]
        then
            # /etc/os-release has all the information
            distribRelString=$(awk -F '=' '/^ID=/ {print $2}' /etc/os-release)
            distribRelMajNum=$(awk -F '=' '/^VERSION_ID=/ {print $2}' /etc/os-release | sed -e 's/\.//g' -e 's/"//g')
            distribRel=$(awk -F '=' '/^PRETTY_NAME=/ {print $2}' /etc/os-release)
        fi
        # Parse and format to identify OS if not already set
        if [ -n "$distribRel" -a "$distribRelString" = "Unknown" ]
        then
            # Replace any space or () with _
            # Converts SUSE Linux Enterprise Server 12 (x86_64) to SUSE_Linux_Enterprise_Server_12__x86_64_
            distribRelString=$(echo ${distribRel//[ ()]/_})
            # Delete any spaces a-z A-Z which will leave Distribution release number and ()
            # Converts "SUSE Linux Enterprise Server 12 (x86_64)" to "12(86_64)"
            distribRelMajNumTemp=$(echo ${distribRel//[a-zA-Z ]/})
            # Replace any () with . and then cut it on "." to get the major release number
            # Converts "12(86_64)" to "12.86_64" and then to "12"
            distribRelMajNum=$(echo ${distribRelMajNumTemp//[()]/.} | cut -d '.' -f1)
            # Replace any () with . and then cut it on "." to get the major release number
            # Converts "12(86_64)" to "12.86_64" and then to "86_64"
            distribRelMinNum=$(echo ${distribRelMajNumTemp//[()]/.} | cut -d '.' -f2)
        fi
        # Flag to track version support
        isSupported="no"
        # Enable case insensitive match
        shopt -s nocasematch
        # Check if distribution release string starts with Red for RedHat
        redHatSearchPattern="^Red"
        if [[ $distribRelString =~ $redHatSearchPattern ]]
        then
            # RHEL 7 and above is supported
            if [ ${distribRelMajNum} -ge 7 ]
            then
                isSupported="yes"
            fi
        fi
        if [ "${isSupported}" = "no" ]
        then
            echo "%{ens_selinux_prod_name} is not supported on this distribution - ${distribRel}"
            exit 1
        else
            echo "%{ens_selinux_prod_name} is installing on - ${distribRel}"
        fi

        # Ensure selinux-policy is installed
        installedSELinuxPolicyVersionString=$(rpm -q --queryformat '%%{VERSION}.%%{RELEASE}\n' selinux-policy)
        if [ $? -ne 0 ]
        then
            echo "selinux-policy should be installed for installation to continue."
            exit 1
        fi
%if 0%{?restrict_policy_load} == 1
        installedSELinuxPolicyVersionString=$(echo ${installedSELinuxPolicyVersionString} | sed -e 's/.el7.*//g' -e 's/.el8.*//g' -e 's/.el9.*//g')
        # Check if minimum supported selinux-policy is installed (spec already has this in requires, but it may have been over-ridden)
        # If installedSELinuxPolicyVersionString is less than min_selinux_policy_version_supported, it will return 2
        # It returns 0 if it is equal
        vercomp "${installedSELinuxPolicyVersionString}" %{min_selinux_policy_version_supported}
        if [ $? -eq 2 ]
        then
            echo "Minimum version of selinux-policy %{min_selinux_policy_version_supported} should be installed for installation to continue."
            exit 1
        fi
%endif
    ;;
    2)  # Build to build Upgrade
%if 0%{?restrict_policy_load} == 1
        installedSELinuxPolicyVersionString=$(rpm -q --queryformat '%%{VERSION}.%%{RELEASE}\n' selinux-policy | sed -e 's/.el7.*//g' -e 's/.el8.*//g' -e 's/.el9.*//g')
        # Check if minimum supported selinux-policy is installed (spec already has this in requires, but it may have been over-ridden)
        # If installedSELinuxPolicyVersionString is less than min_selinux_policy_version_supported, it will return 2
        # It returns 0 if it is equal
        vercomp "${installedSELinuxPolicyVersionString}" %{min_selinux_policy_version_supported}
        if [ $? -eq 2 ]
        then
            echo "Minimum version of selinux-policy %{min_selinux_policy_version_supported} should be installed for upgrade to continue."
            exit 1
        fi
%endif
    ;;
    *)  # Unknown
        true
    ;;
esac

%post
installType=$1
installedSELinuxPolicyVersionString=$(rpm -q --queryformat '%%{VERSION}.%%{RELEASE}\n' selinux-policy | sed -e 's/.el7.*//g' -e 's/.el8.*//g' -e 's/.el9.*//g')
compatibleSELinuxPolicyVersionString=${installedSELinuxPolicyVersionString}
# This is a flag used to determine if policies shipped by this RPM should be loaded
# 0 to not load new policies, 1 to load new policies
loadSELinuxPolicyFlag=1

# Compares two versions a and b and return its value. Both should be in 10.2.2.1105 format
# Returns 1 for more (a > b), 2 for less (a < b) and 0 for equal version (a == b)
function vercomp () {
    if [[ $1 == $2 ]]
    then
        return 0
    fi
    a=$1
    b=$2
    a=$(echo ${a}| sed 's/-/./')
    b=$(echo ${b} | sed 's/-/./')
    local IFS=.
    local i ver1=($a) ver2=($b)
    # fill empty fields in ver1 with zeros
    for ((i=${#ver1[@]}; i<${#ver2[@]}; i++))
    do
        ver1[i]=0
    done
    for ((i=0; i<${#ver1[@]}; i++))
    do
        if [[ -z ${ver2[i]} ]]
        then
            # fill empty fields in ver2 with zeros
            ver2[i]=0
        fi
        if ((10#${ver1[i]} > 10#${ver2[i]}))
        then
            return 1
        fi
        if ((10#${ver1[i]} < 10#${ver2[i]}))
        then
            return 2
        fi
    done
    return 0
}

# Compares the currently installed SELinux-policy version against shipped SELinux policies
# This should be called only When multiple policies is enabled,
# Return 0 and sets the version of SELinux policy file which is compatible with installed SELinux-policy
%if 0%{?multiple_policies} == 1
function detectCompatibleBaseSELinuxPolicy()
{
%if %{_rhel} == 9
    # For RHEL 9.x, currently only selinux-policy 34.1.29-1 is supported so we use this version
    compatibleSELinuxPolicyVersionString="34.1.29-1"
%endif
%if %{_rhel} == 8
    # For RHEL 8.x, if installed selinux-policy is more than/equal to 3.14.3-20,
    # then use ensl policy for 3.14.3-20; else use 3.14.1-61
    vercomp ${installedSELinuxPolicyVersionString} 3.14.3-20
    # Returns 2 if installedSELinuxPolicyVersionString is less than 3.14.3-20
    if [ $? -eq 2 ]
    then
        compatibleSELinuxPolicyVersionString="3.14.1-61"
    else
        compatibleSELinuxPolicyVersionString="3.14.3-20"
    fi
%endif
%if %{_rhel} == 7
    # For RHEL 7.x, If installed selinux-policy is more than/equal to 3.13.1-192,
    # then use ensl policy for 3.13.1-229; else use 3.13.1-60
    vercomp ${installedSELinuxPolicyVersionString} 3.13.1-192
    # Returns 2 if installedSELinuxPolicyVersionString is less than 3.13.1-192
    if [ $? -eq 2 ]
    then
        compatibleSELinuxPolicyVersionString="3.13.1-60"
    else
        compatibleSELinuxPolicyVersionString="3.13.1-229"
    fi
%endif
}
%endif

# Function to check whether MA SELinux policies are loaded
function checkForMASELinuxPolicy()
{
    /usr/sbin/semodule -l | grep mfe_ma > /dev/null
    retval=$?
    return ${retval}           
}

# Common function to load SELinuxPolicies
function loadSELinuxPolicies()
{
    # Load the SELinux policies in correct order
    for selinuxvariant in %{selinux_variants}
    do
        for module_name in %{module_name_list}
        do
%if 0%{?multiple_policies} == 1
            /usr/sbin/semodule -s ${selinuxvariant} -i \
                %{ens_selinux_var_dir}/${selinuxvariant}/selinux-${compatibleSELinuxPolicyVersionString}/${module_name}.pp
%else
            /usr/sbin/semodule -s ${selinuxvariant} -i \
                %{ens_selinux_var_dir}/${selinuxvariant}/${module_name}.pp
%endif
            retval=$?
            if [ ${retval} -eq 0 ]
            then
                echo "Successfully loaded SELinux policy (${compatibleSELinuxPolicyVersionString}) ${module_name}.pp"
            else
                echo "SELinux policy (${compatibleSELinuxPolicyVersionString}) ${module_name}.pp failed to load with the error code - ${retval}"
                # Refer - https://access.redhat.com/solutions/3543691 for a common issue of policy db mismatch
            fi
        done
    done
}

# Common function to start all ENS Services
function startAllENSServices()
{
    # Start ENSL ESP if present
    [ -f %{ens_esp_control_script} ]  && %{ens_esp_control_script} start > /dev/null || :
    # Start ENSL TP if present
    [ -f %{ens_tp_control_script} ]  && %{ens_tp_control_script} start > /dev/null || :
    # Start ENSL FW if present
    [ -f %{ens_fw_control_script} ]  && %{ens_fw_control_script} start > /dev/null || :
}

# Common function to stop all ENS Services
function stopAllENSServices()
{
    # Stop ENSL TP if present
    [ -f %{ens_tp_control_script} ]  && %{ens_tp_control_script} stop > /dev/null || :
    # Stop ENSL FW if present
    [ -f %{ens_fw_control_script} ]  && %{ens_fw_control_script} stop > /dev/null || :
    # Stop ENSL ESP if present
    [ -f %{ens_esp_control_script} ]  && %{ens_esp_control_script} stop > /dev/null || :
}

# Common function to restore context of all ENS locations
function restoreENSSELinuxContexts()
{
    # Restore SELinux contexts
    [ -f %{ens_selinux_root_dir}/scripts/update-selinux-context.sh ] && %{ens_selinux_root_dir}/scripts/update-selinux-context.sh > /dev/null || :
}

%if 0%{?multiple_policies} == 1
# Check if a compatible Base SELinux policy is available
detectCompatibleBaseSELinuxPolicy
if [ $? -ne 0 ]
then
    echo "ERROR: Compatible SELinux policy was not found. Product will not run in confined mode"
    # No compatible policies were found, do not load these policies
    loadSELinuxPolicyFlag=0
fi
%endif
checkForMASELinuxPolicy
if [ $? -ne 0 ]
then
    echo "ERROR: McAfee Agent is not running in confined mode. McAfee Endpoint Security for Linux products will also not run in confined mode"
    # Do not load these policies as McAfee Agent policies are not loaded.
    loadSELinuxPolicyFlag=0
fi
case "${installType}" in
    1)  # Install
        echo "Installing %{ens_selinux_prod_name}"
        # In case load of SELinux policy is enabled, then load them and reinitialise services
        if [ ${loadSELinuxPolicyFlag} -eq 1 ]
        then
            stopAllENSServices
            loadSELinuxPolicies
            restoreENSSELinuxContexts
            startAllENSServices
        fi
        ;;
    2)  # Upgrade
        echo "Upgrading %{ens_selinux_prod_name}"
        stopAllENSServices
        # Unload the older SELinux policies in the correct order, since it is an upgrade
        for selinuxvariant in %{selinux_variants}
        do
            for module_name in %{module_name_unload_list}
            do
                /usr/sbin/semodule -s ${selinuxvariant} -r ${module_name} &> /dev/null || :
            done
        done
        # In case load SELinux policy is enabled, then load them.
        if [ ${loadSELinuxPolicyFlag} -eq 1 ]
        then
            loadSELinuxPolicies
        fi
        # Even in case, new SELinux policies could not be loaded, restore context and start services
        restoreENSSELinuxContexts
        startAllENSServices
        ;;
    *)  # Unknown
        ;;
esac

%postun
case "$1" in
    0)  # Uninstall
        echo "Uninstalling %{ens_selinux_prod_name}"
        # Stop ENSL TP if present
        [ -f %{ens_tp_control_script} ]  && %{ens_tp_control_script} stop > /dev/null || :
        # Stop ENSL FW if present
        [ -f %{ens_fw_control_script} ]  && %{ens_fw_control_script} stop > /dev/null || :
        # Stop ENSL ESP if present
        [ -f %{ens_esp_control_script} ]  && %{ens_esp_control_script} stop > /dev/null || :
        # Unload the SELinux policies in the correct order
        for selinuxvariant in %{selinux_variants}
        do
            for module_name in %{module_name_unload_list}
            do
                /usr/sbin/semodule -s ${selinuxvariant} -r ${module_name} &> /dev/null || :
            done
        done
        # Restore SELinux contexts - performs same steps as update-selinux-context.sh
        [ -d %{ens_root_dir} ] && /sbin/restorecon -R %{ens_root_dir} > /dev/null || :
        [ -d %{ens_var_dir} ] && /sbin/restorecon -R %{ens_var_dir} > /dev/null || :
        [ -f %{/etc/ld-mfeensrt-3.0.so.conf} ] && /sbin/restorecon %{/etc/ld-mfeensrt-3.0.so.conf} > /dev/null || :
        [ -f %{/etc/ld-mfeensrt-3.0.so.cache} ] && /sbin/restorecon %{/etc/ld-mfeensrt-3.0.so.cache} > /dev/null || :
        # Forcefully update TP specific SELinux context
        [ -f %{/opt/McAfee/ens/tp/scripts/update-selinux-context.sh} ] && %{/opt/McAfee/ens/tp/scripts/update-selinux-context.sh} force > /dev/null || :
        # Start ENSL ESP if present
        [ -f %{ens_esp_control_script} ]  && %{ens_esp_control_script} start > /dev/null || :
        # Start ENSL TP if present
        [ -f %{ens_tp_control_script} ]  && %{ens_tp_control_script} start > /dev/null || :
        # Start ENSL FW if present
        [ -f %{ens_fw_control_script} ]  && %{ens_fw_control_script} start > /dev/null || :
        # Delete empty directories if left behind
        if [ -d %{ens_selinux_var_dir}/targeted ]
        then
            for selinuxpolicyversion in %{_ens_selinux_policy_version_list}
            do
                [ -d %{ens_selinux_var_dir}/targeted/selinux-${selinuxpolicyversion} ] && \
                    rmdir --ignore-fail-on-non-empty %{ens_selinux_var_dir}/targeted/selinux-${selinuxpolicyversion} || : 
            done
            rmdir --ignore-fail-on-non-empty -p %{ens_selinux_var_dir}/targeted || : 
        fi
        if [ -d %{ens_selinux_root_dir} ]
        then
            rmdir --ignore-fail-on-non-empty -p %{ens_selinux_root_dir} || : 
        fi
        echo "Finished uninstallation"
    ;;
    1)  # Upgrade
        echo "Finished upgrade"
    ;;
    *)  # Unknown
    ;;
esac

%triggerin -- MFEma-selinux
/usr/sbin/semodule -l | grep mfe_ens > /dev/null
if [ $? -ne 0 ]
then
    installedSELinuxPolicyVersionString=$(rpm -q --queryformat '%%{VERSION}.%%{RELEASE}\n' selinux-policy | sed -e 's/.el7.*//g' -e 's/.el8.*//g' -e 's/.el9.*//g')
    compatibleSELinuxPolicyVersionString=${installedSELinuxPolicyVersionString}
    # This is a flag used to determine if policies shipped by this RPM should be loaded
    # 0 to not load new policies, 1 to load new policies
    loadSELinuxPolicyFlag=1

    # Compares two versions a and b and return its value. Both should be in 10.2.2.1105 format
    # Returns 1 for more (a > b), 2 for less (a < b) and 0 for equal version (a == b)
    function vercomp () {
        if [[ $1 == $2 ]]
        then
            return 0
        fi
        a=$1
        b=$2
        a=$(echo ${a}| sed 's/-/./')
        b=$(echo ${b} | sed 's/-/./')
        local IFS=.
        local i ver1=($a) ver2=($b)
        # fill empty fields in ver1 with zeros
        for ((i=${#ver1[@]}; i<${#ver2[@]}; i++))
        do
            ver1[i]=0
        done
        for ((i=0; i<${#ver1[@]}; i++))
        do
            if [[ -z ${ver2[i]} ]]
            then
                # fill empty fields in ver2 with zeros
                ver2[i]=0
            fi
            if ((10#${ver1[i]} > 10#${ver2[i]}))
            then
                return 1
            fi
            if ((10#${ver1[i]} < 10#${ver2[i]}))
            then
                return 2
            fi
        done
        return 0
    }

    # Compares the currently installed SELinux-policy version against shipped SELinux policies
    # This should be called only When multiple policies is enabled,
    # Return 0 and sets the version of SELinux policy file which is compatible with installed SELinux-policy
    %if 0%{?multiple_policies} == 1
    function detectCompatibleBaseSELinuxPolicy()
    {
    %if %{_rhel} == 9
    # For RHEL 9.x, currently only selinux-policy 34.1.29-1 is supported so we use this version
    compatibleSELinuxPolicyVersionString="34.1.29-1"
    %endif
    %if %{_rhel} == 8
        # For RHEL 8.x, if installed selinux-policy is more than/equal to 3.14.3-20,
        # then use ensl policy for 3.14.3-20; else use 3.14.1-61
        vercomp ${installedSELinuxPolicyVersionString} 3.14.3-20
        # Returns 2 if installedSELinuxPolicyVersionString is less than 3.14.3-20
        if [ $? -eq 2 ]
        then
            compatibleSELinuxPolicyVersionString="3.14.1-61"
        else
            compatibleSELinuxPolicyVersionString="3.14.3-20"
        fi
    %endif
    %if %{_rhel} == 7
        # For RHEL 7.x, If installed selinux-policy is more than/equal to 3.13.1-192,
        # then use ensl policy for 3.13.1-229; else use 3.13.1-60
        vercomp ${installedSELinuxPolicyVersionString} 3.13.1-192
        # Returns 2 if installedSELinuxPolicyVersionString is less than 3.13.1-192
        if [ $? -eq 2 ]
        then
            compatibleSELinuxPolicyVersionString="3.13.1-60"
        else
            compatibleSELinuxPolicyVersionString="3.13.1-229"
        fi
    %endif
    }
    %endif

    # Common function to load SELinuxPolicies
    function loadSELinuxPolicies()
    {
        # Load the SELinux policies in correct order
        for selinuxvariant in %{selinux_variants}
        do
            for module_name in %{module_name_list}
            do
    %if 0%{?multiple_policies} == 1
                /usr/sbin/semodule -s ${selinuxvariant} -i \
                    %{ens_selinux_var_dir}/${selinuxvariant}/selinux-${compatibleSELinuxPolicyVersionString}/${module_name}.pp
    %else
                /usr/sbin/semodule -s ${selinuxvariant} -i \
                    %{ens_selinux_var_dir}/${selinuxvariant}/${module_name}.pp
    %endif
                retval=$?
                if [ ${retval} -eq 0 ]
                then
                    echo "Successfully loaded SELinux policy (${compatibleSELinuxPolicyVersionString}) ${module_name}.pp"
                else
                    echo "SELinux policy (${compatibleSELinuxPolicyVersionString}) ${module_name}.pp failed to load with the error code - ${retval}"
                    # Refer - https://access.redhat.com/solutions/3543691 for a common issue of policy db mismatch
                fi
            done
        done
    }

    # Common function to start all ENS Services
    function startAllENSServices()
    {
        # Start ENSL ESP if present
        [ -f %{ens_esp_control_script} ]  && %{ens_esp_control_script} start > /dev/null || :
        # Start ENSL TP if present
        [ -f %{ens_tp_control_script} ]  && %{ens_tp_control_script} start > /dev/null || :
        # Start ENSL FW if present
        [ -f %{ens_fw_control_script} ]  && %{ens_fw_control_script} start > /dev/null || :
    }

    # Common function to stop all ENS Services
    function stopAllENSServices()
    {
        # Stop ENSL TP if present
        [ -f %{ens_tp_control_script} ]  && %{ens_tp_control_script} stop > /dev/null || :
        # Stop ENSL FW if present
        [ -f %{ens_fw_control_script} ]  && %{ens_fw_control_script} stop > /dev/null || :
        # Stop ENSL ESP if present
        [ -f %{ens_esp_control_script} ]  && %{ens_esp_control_script} stop > /dev/null || :
    }

    # Common function to restore context of all ENS locations
    function restoreENSSELinuxContexts()
    {
        # Restore SELinux contexts
        [ -f %{ens_selinux_root_dir}/scripts/update-selinux-context.sh ] && %{ens_selinux_root_dir}/scripts/update-selinux-context.sh > /dev/null || :
    }

    %if 0%{?multiple_policies} == 1
    # Check if a compatible Base SELinux policy is available
    detectCompatibleBaseSELinuxPolicy
    if [ $? -ne 0 ]
    then
        echo "ERROR: Compatible SELinux policy was not found. Product will not run in confined mode"
        # No compatible policies were found, do not load these policies
        loadSELinuxPolicyFlag=0
    fi
    %endif
    /usr/sbin/semodule -l | grep mfe_ma > /dev/null
    if [ $? -ne 0 ]
    then
        echo "ERROR: McAfee Agent is not running in confined mode. McAfee Endpoint Security for Linux products will also not run in confined mode"
        # No compatible policies were found, do not load these policies
        loadSELinuxPolicyFlag=0
    fi
    echo "Installing %{ens_selinux_prod_name}"
    # In case load of SELinux policy is enabled, then load them and reinitialise services
    if [ ${loadSELinuxPolicyFlag} -eq 1 ]
    then
        stopAllENSServices
        loadSELinuxPolicies
        restoreENSSELinuxContexts
        startAllENSServices
    fi
fi

%triggerun -- MFEma-selinux
# If this is an upgrade of MA SELinux, then do not do anything.
# $2 is the number of instances of the target package which will remain.
[ $2 = 0 ] || exit 0
# Stop ENSL TP if present
[ -f %{ens_tp_control_script} ]  && %{ens_tp_control_script} stop > /dev/null || :
# Stop ENSL FW if present
[ -f %{ens_fw_control_script} ]  && %{ens_fw_control_script} stop > /dev/null || :
# Stop ENSL ESP if present
[ -f %{ens_esp_control_script} ]  && %{ens_esp_control_script} stop > /dev/null || :
# Unload the SELinux policies in the correct order
for selinuxvariant in %{selinux_variants}
do
    for module_name in %{module_name_unload_list}
    do
        /usr/sbin/semodule -s ${selinuxvariant} -r ${module_name} &> /dev/null || :
    done
done
# Restore SELinux contexts - performs same steps as update-selinux-context.sh
[ -d %{ens_root_dir} ] && /sbin/restorecon -R %{ens_root_dir} > /dev/null || :
[ -d %{ens_var_dir} ] && /sbin/restorecon -R %{ens_var_dir} > /dev/null || :
[ -f %{/etc/ld-mfeensrt-3.0.so.conf} ] && /sbin/restorecon %{/etc/ld-mfeensrt-3.0.so.conf} > /dev/null || :
[ -f %{/etc/ld-mfeensrt-3.0.so.cache} ] && /sbin/restorecon %{/etc/ld-mfeensrt-3.0.so.cache} > /dev/null || :
# Forcefully update TP specific SELinux context
[ -f %{/opt/McAfee/ens/tp/scripts/update-selinux-context.sh} ] && %{/opt/McAfee/ens/tp/scripts/update-selinux-context.sh} force > /dev/null || :
# Start ENSL ESP if present
[ -f %{ens_esp_control_script} ]  && %{ens_esp_control_script} start > /dev/null || :
# Start ENSL TP if present
[ -f %{ens_tp_control_script} ]  && %{ens_tp_control_script} start > /dev/null || :
# Start ENSL FW if present
[ -f %{ens_fw_control_script} ]  && %{ens_fw_control_script} start > /dev/null || :


%files -f  %{ens_selinux_prod_name}/files.lst
%defattr(-,root,root,0755)
%dir %{ens_selinux_root_dir}
%license %{ens_selinux_root_dir}/license.txt
%dir %{ens_selinux_root_dir}/scripts
%{ens_selinux_root_dir}/scripts/update-selinux-context.sh
%dir %{ens_selinux_root_dir}/scripts
%dir %{ens_var_dir}
%dir %{ens_selinux_var_dir}
%dir %{ens_selinux_var_dir}/targeted

%changelog
* Tue Apr 14 2020 Abhisek Sanyal <abhisek_sanyal@mcafee.com> 10.7.0-6
- Initial version
