#!/bin/bash
# Copyright (C) 2021 McAfee, LLC. All Rights Reserved.
# Script to verify if process has been modified after installation
# This script always exits with a return code of 0

ps -o args= -p "$$" | grep bash > /dev/null
if [ $? -ne 0 ]
then
    echo "Error: This script can be run by bash shell only"
    echo "Allowlisted process verification helper script for Trellix Endpoint Security for Linux Threat Prevention"
    exit 0
fi

# Check if script is executed as root
ID="$(id -u)"
if [ $? -ne 0 -o "$ID" -ne 0 ]
then
    echo "Must be root / sudo user to execute this script"
    exit 0
fi

usage()
{
    echo "Usage: $0 [processName] [distributionType]"
    echo "Run this script to verify if process has been modified after installation"
    echo "Provide the path of the process to verify"
    echo "Provide the type of distribution rpm/deb"
    exit 0
}

if [ $# -ne 2 ]
then
    usage
fi

PROCESS_NAME=$1
DISTRIBUTION_TYPE=$2

if [ "${DISTRIBUTION_TYPE}" = "rpm" ]
then
    CHECK_CMD="rpm -qf "
    VERIFY_CMD="rpm -V"
elif [ "${DISTRIBUTION_TYPE}" = "deb" ]
then
    CHECK_CMD="dpkg -S "
    VERIFY_CMD="dpkg --verify"
else
    usage
fi

PROCESS_INEGRITY_CMD=$(${CHECK_CMD} ${PROCESS_NAME} | awk -F ': ' '{print $1}' | xargs  ${VERIFY_CMD})
if [ -z "$PROCESS_INEGRITY_CMD" ]
then
    echo 0
else
    echo $PROCESS_INEGRITY_CMD
fi

exit 0
