#!/bin/bash
# Copyright (C) 2016-2022 Musarubra US LLC. All rights reserved.

# Use only bash for executing the script

ps -o args= -p "$$" | grep bash > /dev/null
if [ $? -ne 0 ]
then
     echo "Error: This script can be run by bash shell only"
     echo "cgroup mount helper script for Trellix Endpoint Security for Linux Threat Prevention"
     exit -1
fi

PATH=$PATH:/sbin:/usr/sbin:/bin:/usr/bin

#Reference link: http://man7.org/linux/man-pages/man7/cgroups.7.html
KERNEL_VERSION_MAJOR_REQUIRED_FOR_CGROUP=2
KERNEL_VERSION_MINOR_REQUIRED_FOR_CGROUP=6
KERNEL_VERSION_PATCH_REQUIRED_FOR_CGROUP=24
REQUIRED_KERNEL_VERSION_VALUE=$(($((KERNEL_VERSION_MAJOR_REQUIRED_FOR_CGROUP << 16)) + $((KERNEL_VERSION_MINOR_REQUIRED_FOR_CGROUP << 8)) + $((KERNEL_VERSION_PATCH_REQUIRED_FOR_CGROUP))))

SYSTEMD_DEFAULT_CPU_CGROUP_PATH="/sys/fs/cgroup/cpu,cpuacct"
SYSTEMD_DEFAULT_CPU_CGROUP_PATH_PATTERN="\/sys\/fs\/cgroup\/cpu,cpuacct"
UPSTART_SYSVINIT_DEFAULT_CPU_CGROUP_PATH="/cgroup/cpu"
UPSTART_SYSVINIT_DEFAULT_CPU_CGROUP_PATH_PATTERN="\/cgroup\/cpu"
SYSTEMD_DISTRO_STRING="systemd"
SCRIPT_LOGGER_TAG="ENSLCGroupMountHelper"

DISTRIBUTION_TYPE=$1

function checkUser()
{
    # Check control script is executed as root
    ID="$(id -u)"
    if [ $? -ne 0 -o "$ID" -ne 0 ]
    then
        echo "Must be root / sudo user to run ${BASH_SOURCE}"
        exit -1
    fi
}


#This function checks for distribution init system type (provided
#by caller of script) and based on that tries to mount cpu cgroup
#at default location if it is not already mounted

function mountCGroupIfSupportedAndNotMounted()
{
    if [[ ${DISTRIBUTION_TYPE} != '' && ${DISTRIBUTION_TYPE} = ${SYSTEMD_DISTRO_STRING} ]]; then
        SYSTEMD_MOUNT_AVAILABLE=$(cat /proc/mounts | grep cgroup | grep -w "cpu" | grep -w ${SYSTEMD_DEFAULT_CPU_CGROUP_PATH_PATTERN} | wc -l)
        if [[ $SYSTEMD_MOUNT_AVAILABLE -lt 1 ]]; then
            #check cgroup2 is mounted or not, if cgroup2 is not mounted then mount cgroup1
            SYSTEMD_MOUNT_AVAILABE_CGROUP2=$(cat /proc/mounts |grep cgroup2 |wc -l)
            if [[ $SYSTEMD_MOUNT_AVAILABE_CGROUP2 -lt 1 ]]; then
                $(mkdir -p /sys/fs/cgroup/cpu,cpuacct) > /dev/null 2>&1
                $(mount -t cgroup -o cpu cgroup ${SYSTEMD_DEFAULT_CPU_CGROUP_PATH}) > /dev/null 2>&1
                if [[ $(echo $?) -eq 0 ]]; then
                    logger -i -t ${SCRIPT_LOGGER_TAG} "Successfully mounted cpu cgroup at ${SYSTEMD_DEFAULT_CPU_CGROUP_PATH}"
                else
                    logger -i -t ${SCRIPT_LOGGER_TAG} "Failed to mount cpu cgroup at ${SYSTEMD_DEFAULT_CPU_CGROUP_PATH}"
                fi
            else
                logger -i -t ${SCRIPT_LOGGER_TAG} "Cgroup2 is mounted"
            fi
        fi
    else
        KERNEL_VERSION_STRING=$(awk -F - '{print $1}' <<< "$(uname -r)")
        KERNEL_VERSION_MAJOR=$(awk -F . '{print $1}' <<< "${KERNEL_VERSION_STRING}")
        KERNEL_VERSION_MINOR=$(awk -F . '{print $2}' <<< "${KERNEL_VERSION_STRING}")
        KERNEL_VERSION_PATCH=$(awk -F . '{print $3}' <<< "${KERNEL_VERSION_STRING}")
        CURRENT_KERNEL_VERSION_VALUE=$(($((KERNEL_VERSION_MAJOR << 16)) + $((KERNEL_VERSION_MINOR << 8)) + $((KERNEL_VERSION_PATCH))))
        if [[ ${CURRENT_KERNEL_VERSION_VALUE} -ge ${REQUIRED_KERNEL_VERSION_VALUE} ]]; then
            SYSVINIT_UPSTART_MOUNT_AVAILABLE=$(cat /proc/mounts | grep cgroup | grep -w "cpu" | grep -w ${UPSTART_SYSVINIT_DEFAULT_CPU_CGROUP_PATH_PATTERN} | wc -l)
            if [[ $SYSVINIT_UPSTART_MOUNT_AVAILABLE -lt 1 ]]; then
                $(mkdir -p /cgroup/cpu) > /dev/null 2>&1
                $(mount -t cgroup -o cpu cgroup ${UPSTART_SYSVINIT_DEFAULT_CPU_CGROUP_PATH}) > /dev/null 2>&1
                if [[ $(echo $?) -eq 0 ]]; then
                    logger -i -t ${SCRIPT_LOGGER_TAG} "Successfully mounted cpu cgroup at ${UPSTART_SYSVINIT_DEFAULT_CPU_CGROUP_PATH}"
                else
                    logger -i -t ${SCRIPT_LOGGER_TAG} "Failed to mount cpu cgroup at ${UPSTART_SYSVINIT_DEFAULT_CPU_CGROUP_PATH}"
                fi
            fi
        fi
    fi
}

checkUser
mountCGroupIfSupportedAndNotMounted

exit 0
