/*
 * Define string ops: strchr strrchr memcmp memmove memset 
 */

#ifndef  _ntp_string_h
#define  _ntp_string_h

#ifdef HAVE_MEMORY_H
# include <memory.h>
#endif

#ifdef STDC_HEADERS
# include <string.h>
#else
# ifndef HAVE_STRCHR
#  include <strings.h>
#  define strchr index
#  define strrchr rindex
# endif
char *strchr(), *strrchr();
# ifndef HAVE_MEMCPY
#  define NTP_NEED_BOPS
# endif
#endif /* STDC_HEADERS */

#ifdef NTP_NEED_BOPS
# define memcmp(a,b,c) bcmp(a,b,c)
# define memmove(t,f,c) bcopy(f,t,c)
# define memset(a,x,c) if (x == 0x00) bzero(a,c); else ntp_memset((char*)a,x,c)
void ntp_memset P((char *, int, int));

#endif /*  NTP_NEED_BOPS */

#endif /* _ntp_string_h */
