/***************************************************************************
 * LPRng - An Extended Print Spooler System
 *
 * Copyright 1988-1995 Patrick Powell, San Diego State University
 *     papowell@sdsu.edu
 * See LICENSE for conditions of use.
 *
 ***************************************************************************
 * MODULE: setstatus.c
 * PURPOSE: set status in status file or on screen for user
 **************************************************************************/

/***************************************************************************
 * setstatus()
 * - sets dynamic status when required.
 *   This is actually a misdesign - I wanted to use this only for the
 *   LPD server,  but I then discovered that most of the link supprot
 *   routines used setstatus.  Rather than rip it out,  I added the
 *   Interactive and Verbose flags.  It works... what else can I say...
 *
 *	Mon Aug  7 20:49:45 PDT 1995 Patrick Powell
 ***************************************************************************/
static char *const _id = "$Id: setstatus.c,v 3.0 1996/05/19 04:06:11 papowell Exp $";

#include "lp.h"
#include "lp_config.h"

static int in_setstatus;

/*
 * Error status on STDERR
 */
/* VARARGS2 */
#ifdef HAVE_STDARGS
void setstatus (int kind,char *fmt,...)
#else
void setstatus (va_alist) va_dcl
#endif
{
#ifndef HAVE_STDARGS
    int kind;
    char *fmt;
#endif
	static char *save;
	static int size, minsize;
	char *s, *str;
	int len, l;
	char msg[LINEBUFFER];
	struct stat statb;
	static struct dpathname dpath;
	char *path;
    VA_LOCAL_DECL

    VA_START (fmt);
    VA_SHIFT (kind, int );
    VA_SHIFT (fmt, char *);

	/* prevent recursive calls */
	if( in_setstatus ) return;
	++in_setstatus;
	if( Interactive ){
		if( Verbose ){
			(void) vfprintf ( stderr, fmt, ap);
			(void) fprintf( stderr, "\n" );
		}
		VA_END;
		in_setstatus = 0;
		return;
	}

	(void) vplp_snprintf( msg, sizeof(msg), fmt, ap);
	(void) plp_snprintf( msg+strlen(msg), sizeof(msg)-strlen(msg), " at %s", 
		Time_str(-1,0) );
	DEBUG8("setstatus: new status '%s'", msg );
	safestrncat( msg, "\n" );

	/* append new status to end of old */

	if( CDpathname == 0 || CDpathname->pathname[0] == 0
		|| Printer == 0 || *Printer == 0 || fmt == 0 ){
		in_setstatus = 0;
		return;
	}

	if( Status_fd == 0 ) Status_fd = -1;
	if( Status_fd > 0 && fstat( Status_fd, &statb ) < 0 ){
		path = dpath.pathname;
		logerr( LOG_ERR, "setstatus: cannot stat '%s'", path );
		close( Status_fd );
		Status_fd = -1;
	}
	if( Status_fd < 0 ){
		size = Max_status_size * 1024;
		if( Min_status_size ){
			minsize = Min_status_size * 1024;
		} else {
			minsize = size / 4;
		}
		if( minsize > size ){
			minsize = size;
		}
		
		dpath = *CDpathname;
		path = Add2_path( &dpath, "status.", Printer );
		Status_fd = Checkwrite( path, &statb, O_RDWR, 1, 0 );
		DEBUG8("setstatus: status file '%s'", path);
		if( Status_fd < 0 ){
			logerr_die( LOG_ERR, "setstatus: cannot open '%s'", path );
		}
	}
	path = dpath.pathname;
	/*DEBUG8("setstatus: file '%s', size %d", path, statb.st_size ); */
	str = 0;
	if( size > 0 && statb.st_size > size ){
		/* we truncate it */
		DEBUG8("setstatus: truncating '%s'", path );
		if( save == 0 ){
			malloc_or_die( save, minsize+1 );
		}
		if( lseek( Status_fd, (off_t)(statb.st_size-minsize), 0 ) < 0 ){
			logerr_die( LOG_ERR, "setstatus: cannot seek '%s'", path );
		}
		for( len = minsize, str = save;
			len > 0 && (l = read( Status_fd, str, len ) ) > 0;
			str += l, len -= l );
		*str = 0;
		if( (s = strchr( save, '\n' )) ){
			str = s+1;
		} else {
			str = save;
		}
		if( ftruncate( Status_fd, 0 ) < 0 ){
			logerr_die( LOG_ERR, "setstatus: cannot truncate '%s'",
				path );
		}
	}

	if( (str && Write_fd_str( Status_fd, str ) < 0 )
			|| Write_fd_str( Status_fd, msg ) < 0 ){
		logerr_die( LOG_ERR, "setstatus: write to status file failed" );
	}
	in_setstatus = 0;
	VA_END;
}
