// -*- C++ -*-

// Directories in egfs
//
// This program is distributed under the terms of the
// Free Software Foundation General Public Licence.
// See COPYING for details
// Copyright Jeremy Fitzhardinge <jeremy@sw.oz.au> 1994,1995

#pragma implementation

#include "egdir.h"
#include "egfile.h"
#include "egfs.h"

#include <sys/stat.h>
#include <unistd.h>

// Directories are *easy*
egdir::egdir(egfs &fs, Handle h, Inode *p)
      : DirInode(fs, h, p), filesys(fs)
{
	uid = getuid();
	gid = getgid();
	mode = S_IFDIR | 0755;
}

// This constructs the entire directory hierachy for this
// filesystem (i.e. prime it with silly files)
egtopdir::egtopdir(egfs &fs, Handle h, Inode *p)
	 : egdir(fs, h, p)
{
	link("test1", new egfile(fs, fs.genhand(), "Hello, world!\n"));
	link("test2", new egfile(fs, fs.genhand(), "Wooba wooba...\n"));

	DirInode *d1 = new egdir(fs, fs.genhand(), this);
	DirInode *d2 = new egdir(fs, fs.genhand(), this);

	link("dir1", d1);
	link("dir2", d2);

	Inode *f1 = new egfile(fs, fs.genhand(), "File with multiple names\n");
	d1->link("linked-file", f1);
	d2->link("another-link", f1);

	Inode *f2 = new egfile(fs, fs.genhand(), "Piffle woodle.\n");
	d2->link("strange", f2);
}

// Handle file creation.  We only support files and directories (no links,
// devices, etc)
int
egdir::do_create(const up_preamble &, upp_repl &,
		 const upp_create_s &arg, upp_create_r &ret)
{
	Inode *ino;
	Handle h = filesys.genhand();
	
	if (S_ISREG(arg.mode))
	{
		ino = new egfile(filesys, h, NULL, 0);
	}
	else if (S_ISDIR(arg.mode))
	{
		ino = new egdir(filesys, h, this);
	}
	else
		return EINVAL;

	ret.file.handle = ino->gethandle();
	link(String((char *)arg.name.elems, (int)arg.name.nelem), ino);
	return 0;
}

