// -*- C++ -*-

// (C) Copyright 1994 Jeremy Fitzhardinge <jeremy@sw.oz.au>
// This code is distributed under the terms of the
// GNU General Public Licence.  See COPYING for more details.

// Dos ftp server support by marcus@ee.pdx.edu (Marcus Daniels)

#pragma implementation

#include "dos_host.h"
#include "serv_port.h"
#include "ftpconn.h"
#include "getdate.h"
#include <io.h>

#include <unistd.h>
#include <time.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <String.h>
#include <stdio.h>
#include <netinet/in.h>
#include <stdlib.h>

int
dos_host::pathsteps(const String &path, String *ret[])
{
	static const Regex deldot("\\(^\\./\\)\\|\\(/\\.\\/\\)\\|\\(/\\.$\\)\\|\\(//\\)\\|\\(^\\.$\\)");
	static const Regex deldotdot("\\(^|/\\)[^/]+/\\.\\./");
	
	*ret = new String[1];
	(*ret)[0] = path;
	(*ret)[0].gsub(deldot, "");
	(*ret)[0].gsub(deldotdot, "/");

	if ((*ret)[0] == "")
		return 0;
	
	return 1;
}

// Get local time at remote machine with the "time" service
time_t
dos_host::localtime(struct sockaddr_in addr)
{
	return time(0);
}

#define EPOCH		1970
#define HOUR(x)		((time_t)(x) * 60)
#define SECSPERDAY	(24L * 60L * 60L)

// Parse a date from "dir"
static time_t
parsedate(const String &date, time_t timezone)
{
	String parts[2];
	static const Regex rx_date_time_delim(" +");
	String date_parts[3];
	static const Regex rx_date_delim("-");

	if (split(date, parts, 2, rx_date_time_delim) != 2)
		return -1;
	if (split(parts[0], date_parts, 3, rx_date_delim) != 3)
		return -1;
	
	static const Regex rx_time("[012]?[0-9]:[0-5][0-9]");
	static const Regex rx_year("[0-9][0-9]");
	static const Regex rx_month("[0-1][0-9]");
	static const Regex rx_day("[0-9][0-9]");

	int month = -1;
	int day = -1;
	int year = -1;
	int hours = -1;
	int mins = -1;

	if (!date_parts[0].matches(rx_month))
          return 0;
        month = atoi(date_parts[0]);
	if (!date_parts[1].matches(rx_day))
          return 0;
	day = atoi(date_parts[1]);
	if (!date_parts[2].matches(rx_year))
          return 0;
 	year = atoi(date_parts[2]);

	{
		String hm[2];
		if (!parts[1].matches(rx_time))
			return 0;
		if (split(parts[1], hm, 2, String(":")) != 2)
			return 0;
		hours = atoi(hm[0]);
		mins = atoi(hm[1]);
	}	
	return Convert(month, day,
		       year,hours,mins,0,MER24,DSToff,timezone);
}

struct ftp_filelist *
dos_host::parse_filelist(const String &ro_line, time_t timezone)
{
	String line = ro_line;
	
	// Match a line of "dir" output
	static const Regex dir_line_1("^\\([^ /]+\\) *\\([<DIR>0-9]+\\) \\([0-1][0-9]-[0-3][0-9]-[0-9][0-9]  [012][0-9]:[0-5][0-9]\\).*");
	static const Regex dir_line_2("^.*/\\([^ /]+\\) *\\([<DIR>0-9]+\\) \\([0-1][0-9]-[0-3][0-9]-[0-9][0-9]  [012][0-9]:[0-5][0-9]\\).*");

	const Regex *dir_rx = &dir_line_1;
	
	if (!line.matches(dir_line_1))
	{
		if (!line.matches(dir_line_2))
		{
			cout << "Failed to match dir line [" << line << "]\n";
			return NULL;
		}
		dir_rx=&dir_line_2;
	}

	int start, len;

	ftp_filelist *nf = new ftp_filelist;
	dir_rx->match_info(start, len, 1);
	nf->name = String(line.at(start,len));
	
	dir_rx->match_info(start, len, 2);

	String sz_str(line.at(start, len));
	nf->size = strtol(sz_str, NULL, 10);
	switch(sz_str[0])
	{
	case '<':
		nf->type = FT_Directory;
		break;
	default:
		nf->type = FT_File;
		break;
	}

	dir_rx->match_info(start, len, 3);
	String date_str(line.at(start, len));
	cout << "Date_str:[" << date_str << "]\n";
	nf->time = parsedate(date_str, timezone);
	nf->next = NULL;

	struct tm *tm = gmtime(&nf->time);
	cout << "Name " << nf->name << " size " << nf->size <<
		" date " << asctime(tm);

	return nf;
}

const String &
dos_host::hosttype() const
{
	static const String dos("dos");

	return dos;
}

const String &
dos_host::wildcard() const
{
	static const String wild("/*");

	return wild;
}
