// -*- C++ -*-

// (C) Copyright 1994 Jeremy Fitzhardinge <jeremy@sw.oz.au>
// This code is distributed under the terms of the
// GNU General Public Licence.  See COPYING for more details.

#ifndef _FTPFS_H_
#define _FTPFS_H_

#pragma interface

#include <Filesystem.h>
#include <String.h>

// Thread priorities for different classes of threads
// Operations should be quick, so they get timely response.
// UPD_TPRI is higher than COM_TPRI, but it blocks itself to be
// woken by the comm thread, so its really lower priority...
#define OPS_TPRI	7	// Doing operations
#define UPD_TPRI	5	// Updating a file (bulk FTP transfer)
#define COM_TPRI	4	// Waiting for select input

class ftpfs : public Filesystem
{
	String cache;

	Handle hcount;

	Inode *root;
	
public:
	ftpfs(const char *mpoint, const String &cache);
	~ftpfs();

	const uid_t uid;
	const gid_t gid;
	
	int do_mount(const up_preamble &, upp_repl &,
		     upp_mount_r &ret);
	
	int Enquire(up_ops);

	Handle genhand()	{ return hcount++; }
};

#endif /* _FTPFS_H_ */
