// -*- C++ -*-

// (C) Copyright 1994 Jeremy Fitzhardinge <jeremy@sw.oz.au>
// This code is distributed under the terms of the
// GNU General Public Licence.  See COPYING for more details.

#pragma implementation

#include "ftplink.h"
#include "ftpfs.h"
#include "pushd.h"
#include "dir.h"

#include <sys/stat.h>
#include <time.h>
#include <unistd.h>
#include <fcntl.h>

#include <stdio.h>
#include <errno.h>
#include <string.h>

ftplink::ftplink(ftpfs &fs, String lnk, dir *d, String name)
	: ino(fs), link(lnk), d(d), name(name)
{
	if (link[0] == '/')
	{
		int dp = d->depth();
		String pre = "./";
		
		if (dp > 0)
			pre = replicate("../", dp);

		link = link.after(0);
		link.prepend(pre);
	}
	
	int fd = d->open();

	if (fd != -1)
	{
		pushd here(fd);
		symlink(link, name);
	}

	ctime = mtime = time(0);
	mode = S_IFLNK | 0777;
	size = link.length();
}

void
ftplink::decref()
{
	if (nlink-- > 0)
		return;
	
	int fd = d->open();

	if (fd != -1)
	{
		pushd here(fd);
		::unlink(name);
	}
	delete this;
}

int
ftplink::do_readlink(const up_preamble &, upp_repl &,
		     const upp_readlink_s &arg, upp_readlink_r &ret)
{
	ret.name.nelem = link.length();
	ret.name.elems = (signed char *)link.chars();

	return 0;
}
