/* -*- C -*- */

#ifndef _GETDATE_H_
#define _GETDATE_H_

#ifdef __cplusplus
extern "C" {
#endif	

#include <time.h>
#include <sys/timeb.h>

/*
**  Daylight-savings mode:  on, off, or not yet known.
*/
typedef enum _DSTMODE {
    DSTon, DSToff, DSTmaybe
} DSTMODE;

/*
**  Meridian:  am, pm, or 24-hour style.
*/
typedef enum _MERIDIAN {
    MERam, MERpm, MER24
} MERIDIAN;


time_t get_date(char *p, struct timeb *now);
time_t
Convert(time_t Month, time_t Day, time_t Year,
	time_t Hours, time_t Minutes, time_t Seconds,
	MERIDIAN Meridian, DSTMODE DSTmode,
	time_t timezone);

#ifdef __cplusplus
}
#endif

#endif /* _GETDATE_H_ */
