// -*- C++ -*-

// Host-type specific information

// (C) Copyright 1994 Jeremy Fitzhardinge <jeremy@sw.oz.au>
// This code is distributed under the terms of the
// GNU General Public Licence.  See COPYING for more details.

#ifndef _HOST_H_
#define _HOST_H_

#pragma interface

#include <sys/types.h>
#include <String.h>
#include <netinet/in.h>

class host
{
public:
	virtual ~host();

	// Return steps to get to required directory
	virtual int pathsteps(const String &path, String *steps[]) = 0;
	
	// Get local time
	virtual time_t localtime(struct sockaddr_in) = 0;

	// Parse a line of file listing
	virtual struct ftp_filelist *parse_filelist(const String &, time_t) = 0;
	// Return host type identifier
	virtual const String &hosttype() const = 0;
	virtual const String &wildcard() const;
};

#endif /* _HOST_H_ */
