// -*- C++ -*-

// PushD/PopD operations

// (C) Copyright 1994 Jeremy Fitzhardinge <jeremy@sw.oz.au>
// This code is distributed under the terms of the
// GNU General Public Licence.  See COPYING for more details.

#include "pushd.h"

#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdio.h>

pushd::pushd(int dir)
      :dir(dir)
{
	int fd = open(".", O_RDONLY);

	if (fd == -1 || fchdir(dir) == -1)
	{
		perror("pushd::pushd() open or fchdir failed");
		return;
	}
	
	old = fd;
}

pushd::~pushd()
{
	fchdir(old);
	close(old);
	close(dir);
}

	
