// -*- C++ -*-
// Password file management

#include <stdio.h>
#include <pwd.h>
#include <unistd.h>
#include <string.h>
#include <time.h>

struct pwent
{
	uid_t uid;
	gid_t gid;
	int ino;
	char *dir;
	char *name;
	pwent *next;
};

class password
{
	pwent *pwlist;
	int ino;
	time_t update;
public:
	password();
	~password();

	const pwent *entry(int ino);
	const pwent *entry(const char *);
	const pwent *entry(const char *, int len);
	const pwent *getlist() { return pwlist; }
	
	int npwent()	{ return ino; }
};

