// -*- C++ -*-

#ifndef _INTFSINO_H_
#define _INTFSINO_H_

#pragma interface

#include <SimpleInode.h>
#include <String.h>

class intfs;
class ifsDirIno;

class ifsIno: public SimpleInode
{
protected:
	intfs &filesys;
		
	const String name;
	String link;
	ifsDirIno *dir;

	int do_readlink(const up_preamble &, upp_repl &,
			const upp_readlink_s &, upp_readlink_r &);
	int do_followlink(const up_preamble &, upp_repl &,
			  const upp_followlink_s &, upp_followlink_r &);
	int do_write(const up_preamble &, upp_repl &,
		     const upp_write_s &, upp_write_r &);

	void update();

	int open(int mode);
	
public:
	String path();
	ifsIno(intfs &fs, Handle hand, ifsDirIno *, String name, String link);
	~ifsIno();
};

#endif /* _INTFSINO_H_ */
