// -*- C++ -*-

// PushD/PopD operations

#include "pushd.h"

#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdio.h>

pushd::pushd(int dir)
{
	int fd = open(".", O_RDONLY);

	if (fd == -1 || fchdir(dir) == -1)
	{
		fprintf(stderr, "pushd::pushd() open or fchdir failed");
		return;
	}
	
	old = fd;
}

pushd::~pushd()
{
	fchdir(old);
	close(old);
}

	
