/*
 * Force an unmount, ignoring everything
 *
 * This is useful for getting rid of runaway filesystems
 * when muserfs gets confused and leaves the mtab in an
 * inconsistent state.
 */

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <sys/mount.h>

int
main(int argc, char *argv[])
{
	if (argc == 2)
	{
		if (umount(argv[1]) == -1)
			perror("umount");
		else
			exit(0);
	}
	else
		fprintf(stderr, "Usage: %s mount-point\n", argv[0]);
	exit(1);
}
