#ifndef _ARCFS_H
#define _ARCFS_H

#define FAIL(str)	fprintf(stderr, "%s:%d %s failed with errno = %s (%d)\n", __FILE__, __LINE__, str, strerror(errno), errno)
#ifdef DEBUG
#include <stdio.h>
#include <stdlib.h>
#define DB(x)	{x;}
#else
#define DB(x)	/**/
#endif

typedef struct tagDIRENT ARC_DIRENT;

struct tagDIRENT {
  ARC_DIRENT *next;
  /* The directory to which this belongs (or itself if this is the root
     directory).  */
  ARC_DIRENT *pdir;
  /* -1 for a directory.  */
  long size;
  union {
    struct {
      long csize;
      unsigned char *buf;
      unsigned int refc;	/* PRIVATE to `unzip.c'.  */
    } file;
    struct {
      ARC_DIRENT *first;
    } dir;
  } data;
  char *name;
  /* Structure is then expanded to whatever...  */
  char fullname[1];	/* PRIVATE to `zip.c'.  */
};

int a_open (ARC_DIRENT *);
int a_close (ARC_DIRENT *);
int a_read (ARC_DIRENT *, long, long, unsigned long *, unsigned char **);
ARC_DIRENT *arc_read (const char *);

#endif /* _ARCFS_H */
