/* Access Gzip'd TARs.  */

#include "arcvfs.h"

#ifdef ARCFMT_TGZ

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

static const char excmd[] = "tar xOfz %s %s";

ARC_DIRENT *
arc_read_tgz (const char *zipfile)
{
  FILE *fp;
  char buf[4096];
  ARC_DIRENT *first = 0;
  char *name;
  long csize;

  csize = strlen (zipfile);
  if (!((csize > 4 && !strcmp (zipfile + csize - 4, ".tgz"))
	|| (csize > 7 && !strcmp (zipfile + csize - 7, ".tar.gz"))))
    return 0;

  first = create_entry (zipfile, zipfile, 0);
  if (!first)
    return 0;
  first->pdir = first;
  first->size = -1;
  first->data.dir.first = 0;
  first->name = (char *) excmd;

  /* MODE USER/GROUP USIZE MON DD HH:MM YYYY NAME  */
  sprintf (buf, "tar tvfz %s", zipfile);
  fp = popen (buf, "r");
  if (!fp)
    {
      perror (buf);
      return 0;
    }
  while (fgets (buf, sizeof (buf), fp))
    {
      long usize;
      ARC_DIRENT *ent;
      int dir_p;

      name = buf + strlen (buf);
      if (name > buf && name[-1] == '\n')
	*--name = '\0';
      if (name > buf && name[-1] == '/')
	{
	  *--name = '\0';
	  dir_p = 1;
	}
      else
	dir_p = 0;

      name = skip_field (buf); /* MODE */
      name = skip_field (name); /* OWNER/GROUP */
      usize = csize = strtol (name, &name, 10);
      name = skip_field (name); /* MMM */
      name = skip_field (name); /* DD */
      name = skip_field (name); /* HH:MM */
      name = skip_field (name); /* YYYY */
      while (*name == ' ')
	++name;

      ent = create_dirent (name, name, &first->data.dir.first, first);
      if (ent)
	{
	  if (dir_p)
	    {
	      ent->size = -1;
	      ent->data.dir.first = 0;
	    }
	  else
	    {
	      ent->size = usize;
	      ent->data.file.csize = csize;
	      ent->data.file.refc = 0;
	    }
	  ent->next = 0;
	}
    }
  fclose (fp);
  return first;
}

#endif
