// -*- C++ -*-

#pragma implementation

#include "mail.h"

header::header(ifstream *f, String name, streampos begin, int l = 0)
{
 file = f;
 n = name;
 start = begin;
 len = l;
// printf("HEADER STARTED AT %d\n", start);
}

String
header::full()
{
 if(!file)
  puts("FILE NULL POINTER!!!");
 char x[len + 1];
 file->seekg(start);
 file->read(x, len);
 x[len] = 0;
 return x; 
};

// tests in fact is the ifstream OK
void
header::test()
{
 char staf[200];
 streampos p = file->tellg();
 file->seekg(0);
 file->getline(staf, 35);
 puts("HEADER TEST");
 puts(staf);
 file->seekg(p);
}

message::message(ifstream *f, streampos begin, int l = 0)
{
 file = f;
 start = begin;
 len = l;
}

static Regex
 from_left_rx(":.*<"),
 alpha_rx("[A-Za-z]"),
 rubout_leftsc_rx("^: *"),
 rubout_rightless_rx(" *<$"),
 inparen_rx("(.*)"),
 whitespc_rx("[ \n\t]"),
 easyshell_rx("[ /!&@'\"]"),
 rubout_leftpar_rx("^.*("),
 rubout_rightpar_rx(").*$");

void
message::setname(String m)
{ 
 from_name = m.at(from_left_rx);
 if(from_name.index(alpha_rx) >= 0)
 {
  from_name.del(rubout_leftsc_rx);
  from_name.del(rubout_rightless_rx);
  m = from_name;
  int j = 0;
  int i = m.length();
  if(m.at(j, 1) == "\"")
   j++;
  if(m.at(i-1, 1) == "\"")
   i--;
  from_name = m.at(j, i - j); // extract name out of "From " header
 }
 else
 {
  from_name = m.at(inparen_rx);
  if(from_name.index(alpha_rx) >= 0)
  {
   from_name.del(rubout_leftpar_rx);
   from_name.del(rubout_rightpar_rx);
  }
  else
  {
   int j = m.index(" ") + 1;
   int i = m.index(whitespc_rx, j);
   if(i < 0)
    i = m.length();
   if(i > j)
   {
//  from_name = m.at(Regex("<.*>"), j);
    for(; m.at(j, 1) == "<" || m.at(j, 1) == "\""; )
     j++;
    for(; m.at(i-1, 1) == ">" || m.at(i-1, 1) == "\""; )
     i--;
    from_name = m.at(j, i - j); // extract name out of "From " header
   }
  }
 }
 from_name.gsub(easyshell_rx, "_"); // it's easier for shells
}

static Regex num_rx("[0-9]"), capit_rx("[A-Z]");

void
message::setdate(String date)
{
 struct tm tms;
 char month[8];

 char *months[] =
 {
  "Jan", "Feb", "Mar", "Apr", "May", "Jun",
  "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"
 };

// puts((char *)date);
 String dt = date.from(num_rx);
 tms.tm_mday = atoi((char *)dt);
 dt = dt.from(capit_rx);
 int i;
 for(i = 11; i >= 0; i--)
  if(dt.index(months[i]) >= 0)
   break;
 tms.tm_mon = i;
 dt = dt.from(num_rx);
 tms.tm_year = atoi((char *)dt);
 if(tms.tm_year >= 1900)
  tms.tm_year -= 1900;
 dt = dt.after(" ");
 tms.tm_hour = atoi((char *)dt);
 dt = dt.after(":");
 tms.tm_min = atoi((char *)dt);
 dt = dt.after(":");
 tms.tm_sec = atoi((char *)dt);
 dt = dt.after(" ");
 tms.tm_isdst = -1;
 int plus = atoi((char *)dt);
 long int pz = (plus % 100) * 60 + (plus / 100) * 3600;
 d = mktime(&tms);
 d += - pz - timezone;
 if(daylight)
  d += 3600;
}

/*
message::message(String msg = "")
{
 int i, j, k, p, r;
 Pix a;
 
 m = msg;

 j = m.index(" ") + 1;
 i = m.index(Regex("[ \n\t]"), j);
 if(i > j)
 {
//  from_name = m.at(Regex("<.*>"), j);
  if(m.at(j, 1) == "<")
   j++;
  if(m.at(i-1, 1) == ">")
   i--;
  from_name = m.at(j, i - j); // extract name out of "From " header
  from_name.gsub(Regex("[ /!&@']"), "_"); // it's easier for shells
 }
 for(k = 0, p = i = m.index("\n") + 1; i < m.length(); i = j + 1, k++ )
 {
  j = m.index("\n", i);
  if(j < 0)
   j = m.length(); // if newline is not found, skip to END of message

  if(m.at(i, 1) != "\t" && m.at(i, 1) != 32) 
  { // test if line doesn't begin with TAB/SPC
   if(i > p) // p is the start of previous header line
   {
    // Take care - we are adding PREVIOUS line here
    // once we get sure current line doesn't begin with TAB
    header h = m.at(p, i - p);
    for(r = 0, a = hdrs.first(); a != NULL; hdrs.next(a))
    {
     if(hdrs(a).name() == h.name())
     {
      r++;
      hdrs(a).append(h.full());
      break;
     }
    }
    if(!r)
     hdrs.append(h);
   }
   p = i;
  }
  if(j - i < 1)
   break; // this is empty lin
 }
 b = i;
}
*/

String
message::full()
{
 if(!file)
  return "FILE: NULL POINTER!!!";
 char x[len + 1];
 file->seekg(start);
 file->read(x, len);
 x[len] = 0;
 return x; 
};

String
message::body()
{
 if(!file)
  return "FILE: NULL POINTER!!!";
 int l = len - b;
 char x[l + 1];
 file->seekg(start + b);
 file->read(x, l);
 x[l] = 0;
 return x; 
};


void
message::disp()
{
 int i;
 Pix a;
 String b;

 cout << "----- headers:\n";
 for(i = 0, a = hdrs.first(); a != NULL; hdrs.next(a), i++)
 {
//  hdrs(a).test();
  cout << i << " " << hdrs(a).full();
 }
 b = body();
 cout << "----- body (len = " << b.length() << "):\n" << body() << "-----\n";
}

void
message::test()
{
 char staf[200];
 streampos p = file->tellg();
 file->seekg(0);
 file->getline(staf, 35);
 puts("MESSAGE TEST");
 if(file->eof())
  puts("FILE EOF");
 puts(staf);
 file->seekg(p);
}

mail::mail(ifstream *f)
{
 file = f;
 char line[MAX_LINE_LEN + 1];
 String msg, temp;
 int i = 0, ic, cont_len = -1, line_num = -1, lines = 0;
 streampos st, sp = -1, sn, bm = -1, em, hs = -1;
 int state = FSM_NOTHING;
 message *m = NULL;
 header *h = NULL;
 String hname = "", tname;

 if(!file)
  return;
 for(st = sn = 0; !file->eof(); )
 {
  sp = sn;
  file->getline(line, MAX_LINE_LEN);
  temp = line;
// sn = file->tellg();
// I gave off on tellg() because it's SLOW and people hate it.
// here's a faster hack, but expect BIG trobles if line is
// longer than MAX_LINE_LEN!!!
  sn += temp.length() + 1;
  switch(state)
  {
   case FSM_NOTHING:
    if(!memcmp(line, "From ", 5))
    {
     if(bm >= 0) // soome message has to exist before we append.
     {
      m->setlen(sp - bm);
      messages.append(*m);
     }
     state = FSM_HEADERS;
     i++; // increment message number
     bm = sp; // begin of the message
     hs = cont_len = line_num = -1; // clear header start and Contents-Length
     m = new message(file, bm);
     m->setname(temp);
     hname = "";
    }
    break;
   case FSM_HEADERS:
   {
// take care, for the last header to be appended,
// a final header addition shall be done when
// the empty line is seen.
    char c = *line;
    if(c != '\t' && c != ' ') 
    { // test if line doesn't begin with TAB/SPC
     ic = 0;
     int it = temp.index(Regex("[: ]"));
     tname = temp.before(it); // establish possible header's name
     if(!memcmp(line, "Content-Length:", 15))
     {
      cont_len = atoi(line + it + 1);
     }
     else
      if(!memcmp(line, "Lines:", 6))
      {
       line_num = atoi(line + it + 1);
      }
      else
       if(!memcmp(line, "From:", 5))
       {
	m->setname(temp);
       }
       else
        if(!memcmp(line, "Date:", 5))
        {
	 m->setdate(temp);
        }
     if(hs < 0) // header hasn't begun
     {
      hs = sp; // start the header
      if(tname.length() > 0)
      {
       ic++; // signal - create new header
       hname = tname;
      }
     }
     else
     {
// potential BUG location: if we have multiple headers with same name,
// but not coming in succession, one after another, we are having a problem.
// we cannot represent header contents file with single offset/length
// because header's contents is split in parts.
      if(tname != hname) // just test if the previous isn't the same
      {
       h->setlen(sp - hs); // header length
       m->headers()->append(*h); // append this header, since 
       // since it probably has a different name
       hs = sp;
       if(tname.length() > 0)
       {
        ic++; // signal - create new header
        hname = tname;
       }
      }
     }
     if(ic)
     { // create new header
      h = new header(file, hname, hs);
     }     
    }
    if( temp.length() < 2)
    {
     m->setbody(sn - bm);
     if(cont_len >= 0)
     {
      sp += cont_len;
      sn += cont_len;
      file->seekg(sn);
      m->setlen(sn - bm);      
      messages.append(*m);
      state = FSM_NOTHING;
      bm = -1; // begin of the message
      hs = cont_len = line_num = -1; // clear header start and Contents-Length
      i++; // increment message number
     }
     else
     {
      state = FSM_BODY; // empty line - start body reading
      lines = 0;
     }
     break;
    }
    break;
   }
   case FSM_BODY:
    int nxtmsg = 0;
    if(!memcmp(line, "From ", 5))
    {
     if(bm >= 0) // at least one message has to exist before we append.
     {
      m->setlen(sp - bm);
      messages.append(*m);
     }
     state = FSM_HEADERS;
     bm = sp; // begin of the message
     nxtmsg++;
    }
    else
    {
     if(line_num >= 0 && ++lines > line_num)
     {
      if(bm >= 0) // append.
      {
       m->setlen(sp - bm);
       messages.append(*m);
      }
      state = FSM_NOTHING;
      bm = -1; // begin of the message
      nxtmsg++;      
     }
    }
    if(nxtmsg)
    {
     hs = cont_len = line_num = -1; // clear header start and Contents-Length
     i++; // increment message number
     m = new message(file, bm);
     m->setname(temp);
     hname = "";
     break;
    }
    break;
  }
  conta1:;
 }
 file->clear(); // wipe out eof thing
 if(bm >= 0 && bm < sp)
 {
  m->setlen(sp - bm);
  messages.append(*m); // it has to be one message more!
 }
}

void
mail::disp()
{
 int i;
 Pix a;

 cout << "----- MAIL messages:\n";
 for(i = 0, a = messages.first(); a != NULL; messages.next(a), i++)
  messages(a).disp();
}

/*
int main()
{
 ifstream f("davor");
 mail a(&f);
 a.disp();
 return 0;
}
*/
