// -*- C++ -*-

#ifndef _MAIL_H_
#define _MAIL_H_

#pragma interface

// Header line management

#include <stdio.h>
#include <unistd.h>
#include <String.h>
#include <DLList.h>
#include <sys/file.h>
#include <stdlib.h>
#include <fstream.h>
#include <time.h>

#define MAX_LINE_LEN 256
#define MAX_MSG_LEN 32767

enum { ACT_DATE, ACT_FROM, ACT_CONTENTS_LENGTH, ACT_LINES, ACT_N };
enum { FSM_NOTHING, FSM_HEADERS, FSM_BODY };

class header
{
 String n;
 ifstream *file;
 streampos start;
 int len;
public:
 header(ifstream *, String, streampos, int);
 header() { file = NULL; start = len = 0; };
 String name() { return n; };
 void setlen(int l) { len = l; };
 void test();
 String full();
 void report(ifstream* &rf, streampos &rs, int &rl) 
 { rf = file; rs = start; rl = len; };
};

class message
{
 DLList<header> hdrs;
 String from_name;
 streampos start;
 ifstream *file;
 time_t d;
 int len;
 int b;
public:
 message() { file = NULL; start = len = 0; };
 message(ifstream *, streampos, int);
 void disp();
 String name() { return from_name; };
 String body();
 String full();
 DLList<header> *headers() { return &hdrs; };
 void clear(streampos p) { hdrs.clear(); start = p; };
 void test();
 void setlen(int l) { len = l; };
 void setbody(int bb) { b = bb; };
 void setname(String);
 void report(ifstream* &rf, streampos &rs, int &rl, int &rb, time_t &rt)
 { rf = file; rs = start; rl = len; rb = b; rt = d; };
 void setdate(String);
};

class mail
{
 DLList<message> messages;
 ifstream *file;
public:
 mail(ifstream *);
 ~mail() { };
 void disp();
 DLList<message> contents() { return messages; };
};

#endif /* _MAIL_H_ */
