// -*- C++ -*-

// Example filesystem

#pragma implementation

// Misc headers
#include <GetOpt.h>

// Filesystem related headers
#include <Comm.h>
#include "mailfs.h"
//#include "mailfile.h"
#include "maildir.h"

// A simple constructor for the filesystem
// All this does is pass the arguments to the base class
// and initialize the inode handle counter.
// The counter is for generating unique handles as required.
// The mechanism used is very simple, because there is a bounded
// number of inodes.
mailfs::mailfs(const char *mpoint, const char *mail)
     : Filesystem(mpoint)
{
 hcount=2;
 mail_file = mail;
 ifile = new ifstream(mail);
}

mailfs::~mailfs()
{
 if(ifile)
  delete ifile;
}

// Declare to the kernel which operations we will support.
int
mailfs::Enquire(up_ops op)
{
	switch(op)
	{
	case up_mount:
	case up_iread:
	case up_readdir:
	case up_multireaddir:
	case up_lookup:
	case up_read:
	case up_readlink:
	case up_rename:
	case up_unlink:
		return 0;
	default:
		break;
	}
	return Filesystem::Enquire(op);
}

// Do the mount.  This simply returns the handle of the root
// directory and creates the directory.
int
mailfs::do_mount(const up_preamble &, upp_repl &,
	       upp_mount_r &ret)
{
	Inode *root = new mailtopdir(*this, genhand(), NULL);
	ret.root.handle = root->gethandle();
	return 0;
}

// Parse the arguments from muserfs and construct the filesystem
// and communications.
int
main(int argc, char **argv)
{
 GetOpt getopt(argc, argv, "i:o:m:f:");
 int optch, err = 0;
 int infd, outfd;
 const char *mpoint = "";
 const char *mfile;
 
 mfile = getenv("MAIL");
 infd = outfd = -1;
 while((optch = getopt()) != EOF)
 switch(optch)
 {
  case 'i':
   infd = atoi(getopt.optarg);
   break;
  case 'o':
   outfd = atoi(getopt.optarg);
   break;
  case 'm':
   mpoint = getopt.optarg;
   break;
  case 'f':
   mfile = getopt.optarg;
   break;
  default:
  err++;
 }

 if (err)
 {
  fprintf(stderr, "Usage: %s -i infd -o outfd -m mpoint -f mailfile\n",
	  argv[0]);
  exit(1);
 }

#if 0 && DEBUG
 printf("pid=%d, return to cont\n", getpid());
 getchar();
#endif
 mailfs efs(mpoint, mfile);
 Comm comm(efs, outfd, infd);
 
 if (comm.Run() == -1)
  fprintf(stderr, "%s: Comm.Run() failed!\n", argv[0]);
 
 return 0;
}
