# include	"fslib.h"

typedef struct {
	ulong	sects;		/* # of sectors on media		*/
	ulong	tsize;		/* Sectors per track			*/
	ulong	amap;		/* # of bytes in allocation map		*/
	ulong	csize;		/* cluster size				*/
	ulong	rootdir;	/* lsn of root directory		*/
	uid_t	uid;		/* owner				*/
	gid_t	gid;		/* group				*/
	mode_t	mode;		/* access mode				*/
	unchar	diskid[2];	/* disk-ID (??)				*/
	unchar	dfmt;		/* disk format				*/
	ulong	sectptr;	/* Sectors per track (== tsize)		*/
	ulong	bootlsn;	/* lsn of bootfile			*/
	ulong	bootsiz;	/* size of bootfile			*/
	time_t	ctime;		/* creation time			*/
	char	name[34];	/* name of this disk			*/
	unchar	pdo[32];	/* path descriptor options (??)		*/
	unchar	*almap;		/* the allocation map itself		*/
}	lsn0;

typedef struct {
	ulong	lsn;		/* lsn of this block			*/
	size_t	bcnt;		/* # of blocks for this file		*/
}	fseg;

typedef struct {
	mode_t	mode;		/* file mode				*/
	uid_t	uid;		/* owner and ...			*/
	gid_t	gid;		/* ... gorup				*/
	time_t	mtime;		/* last modification time		*/
	nlink_t	nlink;		/* # of links				*/
	size_t	size;		/* # of bytes in file			*/
	time_t	ctime;		/* creation time			*/
	fseg	*fs;		/* file segment list			*/
}	fdes;

typedef struct {
	char	name[30];	/* filename				*/
	ulong	lsn;		/* lsn of fdes of this file		*/
}	directory;

typedef enum {
	Binary,
	Text,
	Guess
}	Convert;

typedef struct {
	ulong	ocnt;		/* open count for this file		*/
	ulong	handle;		/* handle for this file			*/
	Convert	cvt;		/* convert type				*/
}	openlog;

extern int	read_cache (ulong lsn, ulong off, unchar *ptr, int cnt);
extern Status	init_cache (int tblsize);

extern time_t	osk2time (unchar *ptr);
extern mode_t	osk2mode (unchar *md);
extern lsn0	*osk2lsn0 (unchar *sec);
extern fdes	*osk2fdes (unchar *sec);
extern directory
		*osk2directory (unchar *dr);

extern fdes	*read_fdes (ulong lsn);
extern TBuffer	*read_part (fdes *fd, ulong off, size_t siz);


extern Convert	convert;
extern lsn0	root;
extern int	dfd;
extern int	secsize;
extern unchar	*sector;
extern int	fsegsize;
extern openlog	*olog;
extern ulong	osiz;

