// -*- c++ -*-
//
// C++ classes for making user level filesystems easier
//
// This program is distributed under the terms of the
// Free Software Foundation General Public Licence.
// Copyright Jeremy Fitzhardinge <jeremy@sw.oz.au> 1993

#ifndef __FILESYSTEM_H_SEEN__
#define __FILESYSTEM_H_SEEN__

#include <errno.h>

#include <userfs_types.h>
#include <linux/userfs_fs.h>

#include <Inode.h>
#include <CommBase.h>

#pragma interface

typedef unsigned char Data;
class Comm;

class Filesystem
{
	friend CommBase;
	friend Inode;
	
	const char 	*mpoint;

	CommBase	*comm_p;
	void	setcomm(CommBase *c)	{ comm_p = c; }
	
protected:
	InodeList	inodes;
	virtual int Enquire(up_ops op);

	Handle 		rootdir;
	
	// generate prototypes for operations methods
#define DO(op)	 virtual int do_##op(const up_preamble &, upp_repl &)
#define DOa(op)	 virtual int do_##op(const up_preamble &, upp_repl &, const upp_##op##_s &)
#define DOr(op)	 virtual int do_##op(const up_preamble &, upp_repl &, upp_##op##_r &)
#define DOar(op) virtual int do_##op(const up_preamble &, upp_repl &, const upp_##op##_s &, upp_##op##_r &)
#include "operations.h"
	
public:
	Filesystem(const char *mpoint);
	virtual ~Filesystem();

	Inode *findino(Handle h)	{ return inodes.find(h); }
	
	// Data contains the encoded reply on non-error return
	// It should point to at least 4k of data.
	int DoOp(const up_preamble &, upp_repl &, Data *data);

	CommBase *comm() const	{ return comm_p; }
};

#endif	// __FILESYSTEM_H_SEEN__
