// -*- C++ -*-

#include "lwp.h"
#include "LWP.h"

#include <stdlib.h>

LWP::LWP(int pri)
{
	pcb = initlp(pri);
}

LWP::LWP(int pri, lwp_entry_t entry, int size, int argc, char **argv, void *envp)
{
	pcb = creatp(pri, entry, size, argc, argv, envp);
}

LWP::~LWP()
{
	destroyp(pcb);
}

void
LWP::ready()
{
	readyp(pcb);
}

void *
LWP::getenvp()
{
	return ::getenvp(pcb);
}

void
LWP::setenvp(void *v)
{
	::setenvp(pcb, v);
}

void
yield()
{
	yieldp();
}

void
suicide()
{
	suicidep();
}

Semaphore::Semaphore(int c)
{
	sem = creats(c);
}

Semaphore::~Semaphore()
{
	free(sem);
}

void
Semaphore::signal()
{
	signals(sem);
}

void
Semaphore::wait()
{
	waits(sem);
}
