// -*- C++ -*-

// Light Weight Process class, based on GNU lwp library
// C++ classes Copyright (C) 1994 Jeremy Fitzhardinge <jeremy@sw.oz.au>
// These classes are licenced under the terms of the GNU General Public Licence

#ifndef _LWP_H_
#define _LWP_H_

class LWP
{
	struct pcb *pcb;

public:
	LWP(int pri);
	LWP(int pri, void (*entry)(int, char **, void *), int size, int argc, char **argv, void *envp);
	~LWP();

	void ready();
	void *getenvp();
	void setenvp(void *);
};

void yield();		// Always current thread
void suicide();		// Always current thread

class Semaphore
{
	struct sem *sem;

public:
	Semaphore(int count);
	~Semaphore();

	void signal();
	void wait();
};
	
#endif /* _LWP_H_ */
