/* $Id$ */

/* This method is private to ole_docfile but has dragged out into this
 * file to stop that class becoming too cluttered with stuff that
 * obscures the higher level logic in ole_docfile. Complexity is what
 * is exercising my mind... it takes a lot of extra cycles or amazing
 * I/O before this code really becomes an issue. */

#include <ole/ole.h>

class map: protected ole
{
private:
    /* Constants */
    const int MAP_ENTSIZE=4;     /* Size of entry in file */
    const int OLE_UNUSED=-1;     /* Used element int map */
    
    /* Types */
    class map_entry
    {
    public:
	typedef enum { USED, FREE } sect_type;
	long next;		/* Data in the map */
	sect_type used;		/* In use or not */
	inline map_entry(void) { sect_type=FREE; }
    } map_entry;
    
    map_entry *map;
    long max;
    long free;
    long sect_size;

    /* Specifics */
    virtual int get_sect(unsigned char *);
    virtual int map_sectors(void); 

protected:
    /* load map, inlined so fast inline version of the above work well */
    inline load_map(void *d)
    {
	unsigned buff[SECTOR_SIZE];
	long pos=0;
	int i,ns;
	
	ns=this->map_sectors(d);
	
	m->max=ns*(SECTOR_SIZE/MAP_ENTSIZE);
	m->map=new(map_entry[max]);
	while (ns--!=0)
	{
	    if (!get_sect(d, buff))
	    {
		cerr<<"load_map::could not load sector of map (fatal)\n";
		fatal(1);
	    }
	    for (i=0; i<SECTOR_SIZE; i+=MAP_ENTSIZE)
		map[pos++].next=get_long(buff+i);
	}
    }

public:
    /* whole proceedures */
    void mark_free(map *);

    /* Simpler methods */
    inline void mark_chain(ole_sect sect)
    {
	while (sect>=0 && sect<m->max)
	{
	    m->map[sect].used=USED;
	    sect=m->map[sect].next;
	}
    }

    /* Count a chain */
    inline long count_chain(ole_sect sect) const
    {
	long c=0;
	while (sect>=0 && sect<m->max)
	{
	    c++;
	    sect=m->map[sect].next;
	}
    }

    inline map(long ssize)
    {
	sect_size=ssize;
    }
};



