/* $Id: dir_find.cc,v 1.1 1997/09/03 00:11:42 dps Exp $ */
/* Find directory entry code */

#include <errno.h>
#include <stdlib.h>
#include <string.h>
#include <iostream.h>
#include <ole/ole.h>
#include <ole/ole_common.h>
#include <ole/ole_dir.h>

/* Return pointer to a directory entry or NULL if not found */
ole_base::olefile *ole_dir::__scan_dir(const char *find, olefile *f)
{
    ole_id next, prev;
    olefile *r, *s;

    if (strcmp(f->name, find)==0)
	return f;

    prev=f->s.prev_id;		// Get prev id
    next=f->s.next_id;		// Get next id

    /* Search prev list */
    if (prev!=INVALID_PPS)
    {
	if ((s=(f->d.src)->getfile(prev))==NULL)
	{
	    cerr<<"ole_dir::__scan_dir: could not get id "<<prev
		<<" some file names will be skipped\n";
	    r=NULL;
	}
	else
	    r=this->__scan_dir(find, s);
    }
    if (r!=NULL)
	return r;

    /* Search next list. Due to test above r==NULL here */
    if (next!=INVALID_PPS)
    {
	if ((s=(f->d.src)->getfile(next))==NULL)
	{
	    cerr<<"ole_dir::__scan_dir: could not get id "<<next
		<<" some file names will be skipped\n";
	    /* r==NULL already. */
	}
	else
	   r=this->__scan_dir(find, s); // Only remaining chance
    }

    return r;			// Not found
}

ole_base::olefile *ole_dir::scan_dir(const char *name)
{
    olefile *s;
    ole_id id;

    if (*name=='\0')
	return &dir;		// Deal with NULLS
    
    if (dir.d.type!=DIR)
    {
	errno=ENOTDIR;
	return NULL;
    }

    if (strcmp(".", name)==0)	// Handle .
	return &dir;
    
    if (strcmp("..", name)==0)	// Handle ..
    {
	id=dir.s.parent_id;
	if (id==INVALID_PPS)
	{
	    cerr<<"ole_dir::scan_dir: .. not supported\n";
	    errno=ENOSYS;
	    return NULL;
	}
	if ((s=(dir.d.src)->getfile(id))==NULL)
	{
	    cerr<<"ole_dir::scan_dir could not get .. (id "<<id<<")\n";
	    errno=EIO;
	    return NULL;
	}
	return s;
    }
    
    /* name not null, . or .. here */
    id=dir.s.dir_id;
    if (id==INVALID_PPS)
	return NULL;	/* ?Empty directory */

    if ((s=(dir.d.src)->getfile(id))==NULL)
    {
	cerr<<"ole_dir::scan_dir could not get .. id "<<id
	    <<" (fatal)\n";
	fatal(1);
    }
    return this->__scan_dir(name, s);
}

