/* $Id: file.cc,v 1.2 1997/09/04 02:51:53 dps Exp $ */

#include <stdio.h>
#include <iostream.h>
#include <ole/ole.h>
#include <ole/ole_docfile.h>
#include <ole/ole_common.h>
#include <ole/ole_filetime.h>

/* Structure of a file entry
00 - 3f name in unicode, null terminated
40 - 41 size of name in bytes, including null
42      type of pps
43	*** Unknown ***
44 - 47 previous pps
48 - 4b next pps
4c - 4f directory pps
50 - 5f Class Id
60 - 63 *** Unknown ***
64 - 6b Timestamp 1, FILETIME format
6c - 73 Timestamp 2, FILETIME format
74 - 77 Starting block of property
78 - 7b Size of data
7c - 7f *** Unknown ***

It is likely that at least some of the unknown fields are used for
pertinent information by the microsoft DLL when the file is in
memory. M$ like mmap()ing a file, assuming the strucutures are packed,
first item first and pointing to them directly. Oh, and ints and 16
bits plus all sorts of fun like that too. I avoid this like the plague
for portabilty (long's at offsets mod 4!=0 give total silly results on
ARMs for instance---the value is rotated by address % 4 bytes!!)

ClassId format is

Bytes     4               2    2      8
  Long (little endain)-short-short-8x1 byte
e.g.
Id is: 00020906-0000-0000-c000000000000046
Bytes in file are (word 97 document):
06 09 02 00 00 00 00 00 c0 00 00 00 00 00 00 46

Same word7 document after a little emacs diddling:
Id is: 00020906-0301-0205-c000000000000046
Bytes in file are
06 09 02 00 01 03 05 02 c0 00 00 00 00 00 00 46

The significance of the ID is unclear.
*/

#define OLE_STORAGE 1
#define OLE_STREAM 2
#define OLE_ROOT 5

int ole_docfile::unpack_file(const unsigned char *d, olefile *r)
{
    int i;
    struct filetime ft[2];

    for (i=0; i<0x20; i++)		   // 0x00 to 0x40 is name in unicode
	r->name[i]=d[i<<1];
   
    r->s.prev_id=get_long(d+0x44);	   // 0x44 to 0x47 is prev_id
    r->s.next_id=get_long(d+0x48);	   // 0x48 to 0x4b is next_id
    r->s.dir_id=get_long(d+0x4c);	   // 0x4c to 0x$f is dir_id

#ifdef CLASS_ID
    r->class.l=get_long(d+0x50);	   // 0x50 to 0x5f is class id
    r->class.s1=get_short(d+0x54);
    r->class.s2=get_short(d+0x56);
    for (i=0; i<8; i++)
    {
	r->class.c[i]=*(d+0x58+i);
    }
#endif /* CLASS_ID */

    ft[0].low=get_long(d+0x64);		   // 0x64 to 0x6b is time stamp #1
    ft[0].high=get_long(d+0x68);
    if (ft[0].low!=0 || ft[0].high!=0)
	r->tstamp1=filetime_to_time(ft);   // Convert timestamp
    else
	r->tstamp1=NO_TIME_STAMP;	   // Some things not timestamped

    ft[1].low=get_long(d+0x6c);		   // 0x6c to 0x75 is time stamp #2
    ft[1].high=get_long(d+0x70);
    if (ft[1].low!=0 || ft[1].high!=0)
	r->tstamp2=filetime_to_time(ft+1); // Convert timestamp
    else
	r->tstamp2=NO_TIME_STAMP;	   // Some things not timestamped
 
    r->d.sect=get_long(d+0x74);		   // 0x74 to 0x77 is start sector
    r->size=get_long(d+0x78);		   // 0x78 to 0x78 is size

    switch(*(d+0x42))
    {
    case OLE_STORAGE:
	r->d.storage=NONE;		   // no storage used
	r->d.type=DIR;			   // directory
	break;

    case OLE_STREAM:
	r->d.storage=(r->size<BIG_MIN_SIZE) ? SMALL : BIG; // Small or big
	r->d.type=FILE;			   // file
	break;

    case OLE_ROOT:
	r->d.storage=BIG;		   // Root uses big blocks
	r->d.type=DIR;			   // Root is directory
	break;

    default:
	return 0;			   // Failed
    }
    return 1;
}

ole_base::olefile *ole_docfile::getfile(ole_id id)
{
    off_t offset;
    unsigned char buf[PPS_SIZE];
    static olefile f;

    offset=map_offset(&file_info, (off_t) (id*PPS_SIZE));
    if (offset==EOF)
	return NULL;
    
    in->seekg(offset, ios::beg);
    in->read(buf, PPS_SIZE);
    if (in->fail())
    {
	cerr<<"ole::get_file: read failed (fatal)\n";
	fatal(1);
    }
    if (!unpack_file(buf, &f))
	return NULL;
    f.s.id=id;
    f.d.src=this;
    if (fpps_map!=NULL)
	f.s.parent_id=(fpps_map+id)->dotdot; // use map
    else
	f.s.parent_id=INVALID_PPS;	     // fall back
    return (&f);
}
