/* $Id: fpps_map.cc,v 1.1 1997/09/04 02:33:16 dps Exp $ */
/* Build map of fpps information, heavily recursive */

#include <stdlib.h>
#include <iostream.h>
#include <ole/ole.h>
#include <ole/ole_docfile.h>

void ole_docfile::__recurse_id(ole_id id)
{
    olefile *f;
    
    if ((f=this->getfile(id))==NULL)
    {
	cerr<<"ole::recurse_id: skipping id "<<id
	    <<" files may be missed\n";
	return;
    }
    this->__make_fpps_map(f);
}

void ole_docfile::__make_fpps_map(olefile *f)
{
    ole_id prev, next, dir, id;

    /* Save ids because f will be clobbered */
    id=f->s.id;
    dir=f->s.dir_id;
    prev=f->s.prev_id;
    next=f->s.next_id;
    (fpps_map+id)->used=FULL;	   // Mark entry as used
    if (dir!=INVALID_PPS)
    {
	(fpps_map+dir)->dotdot=id; // Add entry to .. map
	recurse_id(dir);	   // Process directory
    }
    recurse_id(prev);		   // Process previous entries
    recurse_id(next);		   // Process next entries
}

void ole_docfile::make_fpps_map(void)
{
    int max_ids;
    ole_id id;
    int i;
    static const ole_fpps_entry initial_fpps= { INVALID_PPS, EMPTY };

    max_ids=chain_count(&big_map, file_info.d.sect*(SECTOR_SIZE/PPS_SIZE));
    if ((fpps_map=(ole_fpps_entry *) malloc(sizeof(ole_fpps_entry)*max_ids))
	==NULL)
    {
	cerr<<"ole::make_fpps_map: Warning! could not allocate fpps map\n";
	return;
    }
    for (i=0; i<max_ids; i++)
    {
	*(fpps_map+i)=initial_fpps;
    }
    id=file_info.s.dir_id;	 // Get root dir id
    this->recurse_id(id);	 // Build map
    (fpps_map+id)->dotdot=id;	 // .. of root is root
    (fpps_map+id)->used=FULL;	 // The root entry is used.
}
