/* $Id: map_offset.cc,v 1.1 1997/09/04 02:50:54 dps Exp dps $ */

#include <stdio.h>
#include <sys/types.h>
#include <ole/ole.h>
#include <ole/ole_docfile.h>


/* Find offset in file */
off_t ole_docfile::map_offset(const olefile *f, off_t offset) const
{
    long off;
    ole_sect sect;

    if (offset<0)
	return EOF-1;		// Error

    if (f->d.storage==SMALL)
    {
	off=find_offset(&small_map, offset, f->d.sect);
	if (off==EOF || off==EOF-1)
	    return off;		// Error or EOF
	sect=small_objects;
    }
    else
    {
	off=offset;
	sect=f->d.sect;
    }

    sect=find_offset(&big_map, off, sect);
    return (sect==EOF) ? EOF: sect+SECTOR_SIZE;
}
