/* $Id: map_sector.cc,v 1.1 1997/09/05 20:44:37 dps Exp $ */

#include <stdio.h>
#include <sys/types.h>
#include <errno.h>
#include <ole/ole.h>
#include <ole/ole_docfile.h>

/* Return the sector containing offset */
ole::__ole_vsect ole_docfile::map_sector(const olefile *f, off_t offset)
{
    off_t off, sect_off;
    ole_sect sect;
    size_t sect_sz;
    __ole_vsect res;

    if (offset<0)
    {
	res.st_offset=EOF;
	res.file_pos=EOF;
	errno=EINVAL;
	return res;
    }

    if (f->d.storage==SMALL)
    {
	off=offset-offset % SMALL_SECT_SIZE;
	off=find_offset(&small_map, offset, f->d.sect);
	if (off==EOF || off==EOF-1)
	    {
		res.st_offset=EOF; // Start pos EOF
		res.file_pos=EOF;  // Error or EOF
		return res;
	   }
	sect=small_objects;
	sect_sz=SMALL_SECT_SIZE;
    }
    else
    {
	sect_sz=SECTOR_SIZE;
	off=offset-offset % SECTOR_SIZE;
	sect=f->d.sect;
    }
 
    res.file_pos=find_offset(&big_map, off, sect);
    if (res.file_pos!=(off_t) EOF)
	res.file_pos+=SECTOR_SIZE;
    res.st_offset=off;
    res.size=sect_sz;

    return res;
}
