/* $Id$ */

/* Scan chain for given offset */
off_t ole_docfile::map::find_offset(off_t offset, ole_sect sect) const
{
    while (sect>=0 && sect<max)
    {
	if (offset<m->sect_size)
	    return sect*(m->sect_size)+offset; // Found
	offset-=m->sect_size;
	sect=map[sect].next;
    }
    return EOF;
}

__ole_vsect ole_docfile::map::map_sector(off_t offset, ole_sect sect) const
{
    __ole_vsect res;
    off_t start;
    size_t sz;

    while (sect>=0 && sect<max)
    {
	if (offset<m->sect_size)
	{
	    /* Optimisation: combine contiguous sectors so fewer calls here
	     * are needed.
	     */
	    sz=sect_size;
	    while (map[sect].next==sect+1)
	    {
		sect++;
		sz+=sect_size;
	    }
	    res.st=start;
	    res.size=sz;
	    return res;
	}
	offset-=sect_size;
	start+=sect_size;
	sect=map[sect].next;
    }
    res.st=EOF;
    return res;
}


