/* $Id: open_docfile.cc,v 1.3 1997/09/04 02:49:47 dps Exp dps $ */

#include <iostream.h>
#include <ole/ole.h>
#include <ole/ole_docfile.h>

/* Load the next sector from the big map */
int ole_docfile::big_map::get_sect(void *d, unsigned char *buff)
{
    boot_data *h=(boot_data *) d;
    long s;
    
    s=get_long(h->hdr+offset);
    offset+=4;

    /* Now load the sector */
    in->seekg(s*SECTOR_SIZE+SECTOR_SIZE);
    if (!in->fail())
	in->read(buff, SECTOR_SIZE);
    if (in->fail())
    {
	cerr<<"ole::load_sector failed (fatal)\n";
	fatal(4);
    }
}




int ole_docfile::__small_grab_sector(unsigned char *d, void *p)
{
    long *l=(long *) p;
    load_sector(*l, d);
    *l=big_map.map[*l].next;
    return 1;
}

/* Load small object map */
int ole_docfile::load_small_map(const unsigned char *hdr)
{
    long c,sect;
    unsigned char *p;

    /* Fixed information */
    small_map.sect_size=SMALL_SECT_SIZE;

    sect=get_long(hdr+0x3c);
    c=count_chain(&big_map, sect);
    if (c==0)
    {
	small_map.map=NULL;
	small_map.max=0;
	small_map.free=-2;
	return 1;		// Empty, success
    }

    /* Load map */
    load_map(c, &small_map, &grab_sector, (void *) &sect);
    return 1;
}


int ole_docfile::__big_grab_sector(unsigned buf *d, void *p)
{
    struct __big_grab *dp=(struct __big_grab *) p;
    load_sector(get_long(dp->d+dp->offset));
    dp->offset+=4;
    return 1;
}

/* Load large object map */
int ole_docfile::load_big_map(const unsigned char *hdr)
{
    long blocks;
    unsigned char *p;
    struct __big_grab g;


    /* Fixed information */
    big_map.sect_size=SECTOR_SIZE;

    if (blocks<0)
	return 0;
    g.d=hdr;
    g.offset=0x4c;
    load_map(block, &big_map, &__big_grab_sector, (void *) &g);
    return 1;
}

ole_docfile::ole_docfile(istream *in)
{
    unsigned char hdr[SECTOR_SIZE];
    unsigned char *s;
    long blocks,i,j,root_sect;
    
    /* Read in the header "sector" */
    in->read(hdr, SECTOR_SIZE);
    if (in->fail())
    {
	cerr<<"ole::opendoc: could not read header (fatal)\n";
	fatal(5);
    }

    /* Load the big object map */
    if (!(this->load_big_map(hdr)))
    {
	cerr<<"Count not load large object map (fatal)\n";
	fatal(4);
    }

    /* Load the small object map (must load the big map first) */
    if (!(this->load_small_map(hdr)))
    {
	cerr<<"Count not load small object map (fatal)\n";
	fatal(4);
    }

    /* Examine the root entry; FIXME: should handle root entries with id
     * non-zero. Can Microsoft code do this? */
    root_sect=get_long(hdr+0x30);
    strcpy(file_info.name,"File map");
    this->load_sector(root_sect,hdr);
    if (hdr[0x42]!=0x5)
    {
	cerr<<"Oops! Please fix me so I am more sensitive to root entries\n";
	fatal(3);
    }
    small_objects=get_long(hdr+0x74);

    /* Create a fake file for the file information */
    file_info.size=this->chain_count(&big_map, root_sect)*SECTOR_SIZE;
    file_info.d.sect=root_sect;	       // Start is the file entry.
    file_info.d.storage=BIG;	       // uses big blocks
    file_info.d.type=FAKE;	       // not a real file.
    file_info.s.dir_id=0;	       // FIXME: should scan entries for root
    file_info.s.prev_id=INVALID_PPS;   // No previous pps
    file_info.s.next_id=INVALID_PPS;   // No next pps
    file_info.s.parent_id=INVALID_PPS; // Not a real directory
    this->make_fpps_map();	       // Make fpps map

    /* Set cwd to root */
    init_cwd();
}


