/* $Id: enum_dir.cc,v 1.1 1997/09/04 02:52:34 dps Exp $ */
/* Enumerate directory */

#include <iostream.h>
#include <ole/ole.h>
#include <ole/ole_dir.h>

/* Implementation of ole_dir which does the work */

ole::ole_id ole_dir::output(void)
{
    ole_id ret;

    if (p==NULL)
	return INVALID_PPS;	// Basic test

    while (p!=NULL && p->stage!=MID)
    {
	switch(p->stage)
	{
	case LEFT:
	    if (descend(p->data.s.prev_id,p->data.d.src))
		continue;
	    p->stage=MID;
	    break;

	case RIGHT:
	    if (descend(p->data.s.next_id, p->data.d.src))
		continue;
	    if (!this->pop())
		return INVALID_PPS; // pop() returns 0 at EOF and 1 o.w.
	    break;
	}
    }

    ret=p->data.s.id;
    p->stage=RIGHT;
    return ret;
}

int ole_dir::__descend(ole_id id, ole *d)
{
    olefile *f;
    __ole_dir *nd;

    if (id==INVALID_PPS)	// This test never true; just defensive coding
	return 0;		// Can not descend to invalid id.

    if ((f=d->getfile(id))==NULL)
    {
	cerr<<"ole::ole_dir::descend: Warning! failed to get id "<<id<<" some files may be missed\n";
	return 0;
    }

    nd=new(__ole_dir)(f, p);
    p=nd;
    return 1;
}

