/* $Id: time_map_test.c,v 1.2 1997/09/02 22:20:34 dps Exp $ */
/* Test time_to_filetime and filetime_to_time, within limits
 * Perhaps someone would check my calculations. A little reality
 * checking would help too. This code is provided in good faith but
 * if it dies on you then that is your problem (patches accepted
 * when emailed to dps@io.stargate.co.uk)
 */

#if defined(__GNUC__)
#define TEST
#include "time_to_filetime.c"
#include "filetime_to_time.c"

#undef time_to_filetime
#undef filetime_to_time

int main(void)
{
    struct filetime test, good;
    time_t t, tp, tpp;
    int i;

    for (i=0; i<100; i++)
    {
	t=rand();
	good=__mk_ftime(t);
	test=time_to_filetime(t);
	if (good.high!=test.high || good.low!=test.low)
	{
	    fprintf(stderr,
		    "Test failed, t=%08lx\n"
		    "high=%08lx low=%08lx (ok)\n"
		    "high=%08lx low=%08lx (calculated)\n",
		    t, good.high, good.low, test.high, test.low);
	    exit(1);
	}
	tp=__mk_timet(&good);
	tpp=filetime_to_time(&test);
	if (tp!=t)
	{
	    fprintf(stderr,
		    "long long bug detected---reversed %08lx to %08lx\n",
		    t, tp);
	    exit(1);
	}
	if (tpp!=t)
	{
	    fprintf(stderr,
		    "32-bit long bug detected---reversed %08lx to %08lx\n",
		    t, tpp);
	    exit(1);
	}
    }
    fputs("Passed tests OK\n", stdout);
    return 0;
}
#else /* not __GNUC__ */
int main(void)
{
    fputs("Skipping test because you are not using GNU C (this program"
	  "needs the long long extension)\n", stderr);
    return(0);
}
#endif /* __GNUC__ */
