/* $Id: time_to_filetime.c,v 1.6 1997/09/12 00:17:42 dps Exp $ */
/* Un*x time_t to filetime mapping functions. The extra precision
 * filetime's afford seems pointless IMHO because I am skeptical that
 * anyone's clock is within 100ns of the correct time, unless their
 * computer is fitted with an atomic clock (no computer I have seen so
 * far features this hardware).
 */

#include <stdio.h>
#include <time.h>
#include <stdlib.h>
#include <ole/ole_filetime.h>
#include "config.h"

#if SIZEOF_LONG == 8
#define llong long
#elif SIZEOF_LONG_LONG == 8
#define llong long long
#endif

#if SIZEOF_INT == 4
#define u32 unsigned int
#elif SIZEOF_LONG == 4
#define u32 unsigned long
#else
#undef u32
#endif

/* Sanity check */
#if !defined(llong) && !defined(u32)
#error FATAL ERROR: No 32 or 64 bit type found
#endif

#if !defined(llong) || defined(TEST)
/* This code is provided for the sanity of those without (64 bit)
 * long long's which are big win here. It is also bigger and slower
 * than long long's code (the compiler can not spot what we are doing
 * and we can not tell it without long long's or asm.
 */

struct filetime time_to_filetime(time_t t)
{
    u32 temp;
    struct filetime res;
    u32 high, low;

    /* Start multiplication by 10,000,000 here... */
    high=(t>>30)*(78125<<5);	// The shift these bits want is 30+7=32+5
    temp=(t>>15) & 0x7fff;	// Select bits 15 to 29 of t.
    temp*=78125;		// Multiply */
    low=temp<<22;		// Bottom 10 bits are last ten of low
    high+=temp>>10;		// Add in to total
    temp=(t & 0x7fff)*78125;	// Compute low bits
    high+=temp>>25;		// Add top 7 bits to high
    temp<<=7;			// Shift temp
    if (low>0xffffffff-temp)
	high++;			// Simulate carry
    low+=temp;			// Add new to low
    /*... and final manage to complete the job here! Can anyone do better?
     * Warnings: 1. 78125 is 17 bits
     *           2. I only use 3 multiplications here
     *           3. Use of underhand stuff like the carry flag and wider
     *		    than 32 bit result mutliplies not allowed.
     *           4. Any qualifying algorithm must produce an exact result:
     *		    floating point not allowed.
     */

    /* Now bc with obase=16 tells me that
     * 1970-1601=369 and
     * (369/4-369/100)*24*3600*10^7
     *      +(1970-1601)*365*24*3600*10^7=0x019db1de d53e8000
     */
    if (low>0x2ac17fff)		// Number generated from d53e8000 by hand
	high++;			// Simulate carry
    low+=   0xd53e8000;
    high+=  0x019db1de;
    res.low=low;
    res.high=high;
    return res;
}   
#endif /* no llong or TEST */

#if defined(llong)
#if defined(TEST)
#define time_to_filetime __mk_ftime
#endif /* TEST */

/* long long leverage makes it a doddle */
struct filetime time_to_filetime(time_t t)
{
    unsigned llong temp;
    struct filetime res;

    temp=((llong) t)*10000000;
    temp+=((llong) 89)*24*3600*10000000+ \
	((llong) 369)*365*24*3600*10000000;
    res.high=(temp>>32);
    res.low=temp & 0xffffffff;
    return res;
}

#endif /* llong */
