/* $Id: ole.h,v 1.2 1997/09/04 04:53:51 dps Exp dps $ */

/* OLE 2 doc decompostion library, kudos for reverse enigneering format to
 * LAOLA by Martin Schwartz <schwartz@cs.tu-berlin.de>.
 */

#ifdef __cplusplus
#ifndef __ole_h__
#define __ole_h__

#include <stdio.h>
#include <iostream.h>
#include <sys/types.h>
#include <time.h>
#include <ole/ole_filetime.h>
#include <ole/ole_common.h>

class ole;

class ole_base
{
protected:
    /* Types */
    typedef enum { FAKE, FILE, DIR } ole_file_type;	// File or directory
    typedef enum { NONE, SMALL, BIG } ole_storage_type; // Stored format
    typedef long ole_sect;				// Sector
    typedef long ole_id;				// File id number
    
    /* Constants */
    const ole_id INVALID_PPS=-1;       // Invald file id
    const int OLE_FILENAME_MAX=32;     // Maximum OLE filename length
    const long SECTOR_SIZE=512;	       // Virtual sector size
    const long SMALL_SECT_SIZE=64;     // Small object chunk size
    const long BIG_MIN_SIZE=0x1000;    // Smallest "large" object
    const long PPS_SIZE=0x80;	       // Size of a pps
    const long ERROR=-1;	       // Error code

    /* OLE header constants */
    const int HDR_BIG_MAP_N=0x2c;      // Offset in header #block in big
				       // block map.
    const int HDR_BIG_MAP_D=0x4c;      // Offset to list of blocks in big
				       // block list

    typedef struct
    {
	ole_id prev_id, next_id, dir_id; // structure information (opaque)
	ole_id id;			 // id of this file
	ole_id parent_id;		 // parent, not yet implemented
    } __ole_struct;
	
    typedef struct
    {
	ole_sect sect;		       // Start sector
	ole_storage_type storage;      // Stored format
	ole_file_type type;	       // File or directory
	ole *src;		       // Instance data is inside
    } __ole_storage;

    /* sector reading stuff */
    class __ole_vsect
    {
    public:
	off_t start;
	size_t size;
	inline __ole_vsect(void) {}
	inline ~__ole_vsect(void) {}
    };
    virtual __ole_vsect map_sector(const olefile *, off_t);
    inline __ole_vsect map_sector(const olefile *f, off_t off)
    {
	cerr<<"ole_base: map_sector not supported (fatal)\n";
	fatal(1);
    }

public:
    /* Constants */
    const time_t NO_TIME_STAMP=0;      // Object not timestamped.

#ifdef CLASS_ID
    /* Types */
    typedef struct
    {
	long l;
	short s1;
	short s2;
	unsigned char c[8];
    } class_id;			       // Class id lest someone wants it.
#endif /* CLASS_ID */

    typedef struct
    {
	/* Public */
	char name[OLE_FILENAME_MAX];   // FIXME: Should deal with unicode
	time_t tstamp1;		       // Timestamp 1
	time_t tstamp2;		       // Timestamp 2
	size_t size;		       // Size

#ifdef CLASS_ID
	class_id class;		       // Class
#endif /* CLASS_ID */

	__ole_struct s;		       // Structure (opaque)
	__ole_storage d;	       // Storage (opaque)
	/* Storage */
    } olefile;
};

class ole: protected ole_base
{
 private:
    virtual olefile *root_dir(void);
    olefile cwd;
    
 public:
    virtual olefile *getfile(ole_id id);
    olefile *open(const char *);
    inline ole(void) {};
    inline init_cwd(void)
    {
	cwd=*(this->root_dir());
    }
    int chdir(const char *name);
};

#endif /* __ole_h__ */
#endif /* __cplusplus */

