/* $Id: ole_dir.h,v 1.1 1997/09/03 00:11:00 dps Exp $ */

#ifdef __cplusplus
#ifndef __OLE_DIR_H__
#define __OLE_DIR_H__ 1

#include <iostream.h>
#include <ole/ole.h>
#include <ole/ole_common.h>

class ole_dir: private ole_base
{
 private:
    /* Types */
    typedef enum { LEFT, MID, RIGHT, POP } trav_t;

    class __ole_dir
    {
    public:
	trav_t stage;
	olefile data;
	struct __ole_dir *parent;

	inline __ole_dir(const olefile *f, __ole_dir *p)
	{
	    stage=LEFT;
	    data=*f;
	    parent=p;
	};
    };

    /* Data */
    __ole_dir *p;
    olefile dir;

    /* Inline tools */
    inline int pop(void)
    {
	__ole_dir *oldp;
	oldp=p;
	p=p->parent;
	delete(oldp);
	return (p==NULL) ? 0 : 1;
    }

    inline void wipe(void)
    {
	__ole_dir *pp;
	while (p!=NULL)
	{
	    pp=p->parent;
	    delete(p);
	    p=pp;
	}
    }

    /* Heavy methods */
    ole_id output(void);
    int __descend(ole_id, ole *);

    /* Efficiency hack */
    inline int descend(ole_id id, ole *d)
    {
	return (id!=INVALID_PPS) ? __descend(id, d) : 0;
    }

    /* Find name */
    olefile *__scan_dir(const char *, olefile *);

public:
    /* find name method */
    olefile *scan_dir(const char *);

    /* inline stuff */
    inline ole_dir(const olefile *f)
    {
	olefile *s;
	ole_id id;

	dir=*f;
	if ((id=f->s.dir_id)==INVALID_PPS)
	{
	    cerr<<"ole_dir: argument not a diretcory (fatal)\n";
	    fatal(1);
	}
	if ((s=(f->d.src)->getfile(id))==NULL)
	{
	    cerr<<"ole_dir: could not id "<<id<<" (fatal)\n";
	    fatal(1);
	}
	p=new(__ole_dir)(s, NULL);
    }

    inline ~ole_dir(void)
    {
	((ole_dir *) this)->wipe();
    }

    inline closedir(void)
    {
        this->wipe();
	p=NULL;
    }

    inline olefile *readdir(void)
    {
	ole_id id;

	if ((id=this->output())==INVALID_PPS)
	    return NULL;
	return p->data.d.src->getfile(id);
    }
};
#endif /* __OLE_DIR_H__ */
#endif /* __cplusplus */
